"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.settingsServiceFactory = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const settingsServiceFactory = ({
  coreStart
}) => {
  return {
    getDateFormat: () => {
      return coreStart.uiSettings.get('dateFormat', 'MMM D, YYYY @ HH:mm:ss.SSS');
    },
    getTimezone: () => {
      return coreStart.uiSettings.get('dateFormat:tz', 'Browser');
    },
    getDefaultTimeRange: () => {
      const defaultTimeRange = coreStart.uiSettings.get('timepicker:timeDefaults');
      return defaultTimeRange ? defaultTimeRange : {
        from: 'now-15m',
        to: 'now'
      };
    }
  };
};
exports.settingsServiceFactory = settingsServiceFactory;