"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registry = exports.providers = exports.pluginServices = void 0;
var _public = require("@kbn/presentation-util-plugin/public");
var _controls_service = require("./controls/controls_service");
var _core_service = require("./core/core_service");
var _data_service = require("./data/data_service");
var _data_views_service = require("./data_views/data_views_service");
var _embeddable_service = require("./embeddable/embeddable_service");
var _http_service = require("./http/http_service");
var _options_list_service = require("./options_list/options_list_service");
var _overlays_service = require("./overlays/overlays_service");
var _settings_service = require("./settings/settings_service");
var _unified_search_service = require("./unified_search/unified_search_service");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const providers = {
  controls: new _public.PluginServiceProvider(_controls_service.controlsServiceFactory),
  data: new _public.PluginServiceProvider(_data_service.dataServiceFactory),
  dataViews: new _public.PluginServiceProvider(_data_views_service.dataViewsServiceFactory),
  embeddable: new _public.PluginServiceProvider(_embeddable_service.embeddableServiceFactory),
  http: new _public.PluginServiceProvider(_http_service.httpServiceFactory),
  optionsList: new _public.PluginServiceProvider(_options_list_service.optionsListServiceFactory, ['data', 'http']),
  overlays: new _public.PluginServiceProvider(_overlays_service.overlaysServiceFactory),
  settings: new _public.PluginServiceProvider(_settings_service.settingsServiceFactory),
  core: new _public.PluginServiceProvider(_core_service.coreServiceFactory),
  unifiedSearch: new _public.PluginServiceProvider(_unified_search_service.unifiedSearchServiceFactory)
};
exports.providers = providers;
const pluginServices = new _public.PluginServices();
exports.pluginServices = pluginServices;
const registry = new _public.PluginServiceRegistry(providers);
exports.registry = registry;