"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OptionsListEmbeddableFactory = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _fastDeepEqual = _interopRequireDefault(require("fast-deep-equal"));
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/presentation-util-plugin/public");
var _options_list_persistable_state = require("../../../common/options_list/options_list_persistable_state");
var _types = require("../../../common/options_list/types");
var _options_list_editor_options = require("../components/options_list_editor_options");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; } /*
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * or more contributor license agreements. Licensed under the Elastic License
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * 2.0 and the Server Side Public License, v 1; you may not use this file except
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * in compliance with, at your election, the Elastic License 2.0 or the Server
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * Side Public License, v 1.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      */
class OptionsListEmbeddableFactory {
  constructor() {
    (0, _defineProperty2.default)(this, "type", _types.OPTIONS_LIST_CONTROL);
    (0, _defineProperty2.default)(this, "canCreateNew", () => false);
    (0, _defineProperty2.default)(this, "presaveTransformFunction", (newInput, embeddable) => {
      if (embeddable && (newInput.fieldName && !(0, _fastDeepEqual.default)(newInput.fieldName, embeddable.getInput().fieldName) || newInput.dataViewId && !(0, _fastDeepEqual.default)(newInput.dataViewId, embeddable.getInput().dataViewId))) {
        // if the field name or data view id has changed in this editing session, reset all selections
        newInput.selectedOptions = undefined;
        newInput.existsSelected = undefined;
        newInput.exclude = undefined;
        newInput.sort = undefined;
      }
      return newInput;
    });
    (0, _defineProperty2.default)(this, "isFieldCompatible", field => {
      return !field.spec.scripted && field.aggregatable && ['string', 'boolean', 'ip', 'date'].includes(field.type);
    });
    (0, _defineProperty2.default)(this, "controlEditorOptionsComponent", _options_list_editor_options.OptionsListEditorOptions);
    (0, _defineProperty2.default)(this, "isEditable", () => Promise.resolve(true));
    (0, _defineProperty2.default)(this, "getDisplayName", () => _i18n.i18n.translate('controls.optionsList.displayName', {
      defaultMessage: 'Options list'
    }));
    (0, _defineProperty2.default)(this, "getIconType", () => 'editorChecklist');
    (0, _defineProperty2.default)(this, "getDescription", () => _i18n.i18n.translate('controls.optionsList.description', {
      defaultMessage: 'Add a menu for selecting field values.'
    }));
    (0, _defineProperty2.default)(this, "inject", (0, _options_list_persistable_state.createOptionsListInject)());
    (0, _defineProperty2.default)(this, "extract", (0, _options_list_persistable_state.createOptionsListExtract)());
  }
  async create(initialInput, parent) {
    const reduxEmbeddablePackage = await (0, _public.lazyLoadReduxToolsPackage)();
    const {
      OptionsListEmbeddable
    } = await Promise.resolve().then(() => _interopRequireWildcard(require('./options_list_embeddable')));
    return Promise.resolve(new OptionsListEmbeddable(reduxEmbeddablePackage, initialInput, {}, parent));
  }
}
exports.OptionsListEmbeddableFactory = OptionsListEmbeddableFactory;