"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OptionsListPopoverInvalidSelections = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _options_list_strings = require("./options_list_strings");
var _options_list_embeddable = require("../embeddable/options_list_embeddable");
var _use_field_formatter = require("../../hooks/use_field_formatter");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const OptionsListPopoverInvalidSelections = () => {
  var _invalidSelections$le, _invalidSelections$le2;
  const optionsList = (0, _options_list_embeddable.useOptionsList)();
  const fieldName = optionsList.select(state => state.explicitInput.fieldName);
  const invalidSelections = optionsList.select(state => state.componentState.invalidSelections);
  const fieldSpec = optionsList.select(state => state.componentState.field);
  const dataViewId = optionsList.select(state => state.output.dataViewId);
  const fieldFormatter = (0, _use_field_formatter.useFieldFormatter)({
    dataViewId,
    fieldSpec
  });
  const [selectableOptions, setSelectableOptions] = (0, _react.useState)([]); // will be set in following useEffect
  (0, _react.useEffect)(() => {
    /* This useEffect makes selectableOptions responsive to unchecking options */
    const options = (invalidSelections !== null && invalidSelections !== void 0 ? invalidSelections : []).map(key => {
      return {
        key,
        label: fieldFormatter(key),
        checked: 'on',
        className: 'optionsList__selectionInvalid',
        'data-test-subj': `optionsList-control-ignored-selection-${key}`,
        prepend: /*#__PURE__*/_react.default.createElement(_eui.EuiScreenReaderOnly, null, /*#__PURE__*/_react.default.createElement("div", null, _options_list_strings.OptionsListStrings.popover.getInvalidSelectionScreenReaderText(), '" "', " "))
      };
    });
    setSelectableOptions(options);
  }, [fieldFormatter, invalidSelections]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxs",
    className: "optionsList-control-ignored-selection-title",
    "data-test-subj": "optionList__ignoredSelectionLabel"
  }, /*#__PURE__*/_react.default.createElement("label", null, _options_list_strings.OptionsListStrings.popover.getInvalidSelectionsSectionTitle((_invalidSelections$le = invalidSelections === null || invalidSelections === void 0 ? void 0 : invalidSelections.length) !== null && _invalidSelections$le !== void 0 ? _invalidSelections$le : 0))), /*#__PURE__*/_react.default.createElement(_eui.EuiSelectable, {
    "aria-label": _options_list_strings.OptionsListStrings.popover.getInvalidSelectionsSectionAriaLabel(fieldName, (_invalidSelections$le2 = invalidSelections === null || invalidSelections === void 0 ? void 0 : invalidSelections.length) !== null && _invalidSelections$le2 !== void 0 ? _invalidSelections$le2 : 0),
    options: selectableOptions,
    listProps: {
      onFocusBadge: false,
      isVirtualized: false
    },
    onChange: (newSuggestions, _, changedOption) => {
      setSelectableOptions(newSuggestions);
      optionsList.dispatch.deselectOption(changedOption.label);
    }
  }, list => list));
};
exports.OptionsListPopoverInvalidSelections = OptionsListPopoverInvalidSelections;