"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OptionsListControl = void 0;
var _classnames = _interopRequireDefault(require("classnames"));
var _lodash = require("lodash");
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _types = require("../types");
var _options_list_strings = require("./options_list_strings");
var _options_list_popover = require("./options_list_popover");
var _options_list_embeddable = require("../embeddable/options_list_embeddable");
require("./options_list.scss");
var _control_error_component = require("../../control_group/component/control_error_component");
var _constants = require("../../constants");
var _use_field_formatter = require("../../hooks/use_field_formatter");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const OptionsListControl = ({
  typeaheadSubject,
  loadMoreSubject
}) => {
  const optionsList = (0, _options_list_embeddable.useOptionsList)();
  const error = optionsList.select(state => state.componentState.error);
  const isPopoverOpen = optionsList.select(state => state.componentState.popoverOpen);
  const validSelections = optionsList.select(state => state.componentState.validSelections);
  const invalidSelections = optionsList.select(state => state.componentState.invalidSelections);
  const fieldSpec = optionsList.select(state => state.componentState.field);
  const id = optionsList.select(state => state.explicitInput.id);
  const exclude = optionsList.select(state => state.explicitInput.exclude);
  const fieldName = optionsList.select(state => state.explicitInput.fieldName);
  const placeholder = optionsList.select(state => state.explicitInput.placeholder);
  const controlStyle = optionsList.select(state => state.explicitInput.controlStyle);
  const singleSelect = optionsList.select(state => state.explicitInput.singleSelect);
  const existsSelected = optionsList.select(state => state.explicitInput.existsSelected);
  const selectedOptions = optionsList.select(state => state.explicitInput.selectedOptions);
  const loading = optionsList.select(state => state.output.loading);
  const dataViewId = optionsList.select(state => state.output.dataViewId);
  const fieldFormatter = (0, _use_field_formatter.useFieldFormatter)({
    dataViewId,
    fieldSpec
  });
  (0, _react.useEffect)(() => {
    return () => {
      optionsList.dispatch.setPopoverOpen(false); // on unmount, close the popover
    };
  }, [optionsList]);

  // debounce loading state so loading doesn't flash when user types
  const [debouncedLoading, setDebouncedLoading] = (0, _react.useState)(true);
  const debounceSetLoading = (0, _react.useMemo)(() => (0, _lodash.debounce)(latestLoading => {
    setDebouncedLoading(latestLoading);
  }, 100), []);
  (0, _react.useEffect)(() => debounceSetLoading(loading !== null && loading !== void 0 ? loading : false), [loading, debounceSetLoading]);

  // remove all other selections if this control is single select
  (0, _react.useEffect)(() => {
    if (singleSelect && selectedOptions && (selectedOptions === null || selectedOptions === void 0 ? void 0 : selectedOptions.length) > 1) {
      optionsList.dispatch.replaceSelection(selectedOptions[0]);
    }
  }, [selectedOptions, singleSelect, optionsList.dispatch]);
  const updateSearchString = (0, _react.useCallback)(newSearchString => {
    typeaheadSubject.next(newSearchString);
    optionsList.dispatch.setSearchString(newSearchString);
  }, [typeaheadSubject, optionsList.dispatch]);
  const loadMoreSuggestions = (0, _react.useCallback)(cardinality => {
    loadMoreSubject.next(Math.min(cardinality, _types.MAX_OPTIONS_LIST_REQUEST_SIZE));
  }, [loadMoreSubject]);
  const {
    hasSelections,
    selectionDisplayNode,
    validSelectionsCount
  } = (0, _react.useMemo)(() => {
    const delimiter = _options_list_strings.OptionsListStrings.control.getSeparator(fieldSpec === null || fieldSpec === void 0 ? void 0 : fieldSpec.type);
    return {
      hasSelections: !(0, _lodash.isEmpty)(validSelections) || !(0, _lodash.isEmpty)(invalidSelections),
      validSelectionsCount: validSelections === null || validSelections === void 0 ? void 0 : validSelections.length,
      selectionDisplayNode: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, exclude && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("span", {
        className: "optionsList__negateLabel"
      }, existsSelected ? _options_list_strings.OptionsListStrings.control.getExcludeExists() : _options_list_strings.OptionsListStrings.control.getNegate()), ' '), existsSelected ? /*#__PURE__*/_react.default.createElement("span", {
        className: `optionsList__existsFilter`
      }, _options_list_strings.OptionsListStrings.controlAndPopover.getExists(+Boolean(exclude))) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, validSelections !== null && validSelections !== void 0 && validSelections.length ? /*#__PURE__*/_react.default.createElement("span", {
        className: "optionsList__filterValid"
      }, validSelections.map(value => fieldFormatter(value)).join(delimiter)) : null, validSelections !== null && validSelections !== void 0 && validSelections.length && invalidSelections !== null && invalidSelections !== void 0 && invalidSelections.length ? delimiter : null, invalidSelections !== null && invalidSelections !== void 0 && invalidSelections.length ? /*#__PURE__*/_react.default.createElement("span", {
        className: "optionsList__filterInvalid"
      }, invalidSelections.map(value => fieldFormatter(value)).join(delimiter)) : null))
    };
  }, [exclude, existsSelected, validSelections, invalidSelections, fieldFormatter, fieldSpec === null || fieldSpec === void 0 ? void 0 : fieldSpec.type]);
  const button = /*#__PURE__*/_react.default.createElement(_eui.EuiFilterButton, {
    badgeColor: "success",
    iconType: "arrowDown",
    isLoading: debouncedLoading,
    className: (0, _classnames.default)('optionsList--filterBtn', {
      'optionsList--filterBtnSingle': controlStyle !== 'twoLine',
      'optionsList--filterBtnPlaceholder': !hasSelections
    }),
    "data-test-subj": `optionsList-control-${id}`,
    onClick: () => optionsList.dispatch.setPopoverOpen(!isPopoverOpen),
    isSelected: isPopoverOpen,
    numActiveFilters: validSelectionsCount,
    hasActiveFilters: Boolean(validSelectionsCount)
  }, hasSelections || existsSelected ? selectionDisplayNode : placeholder !== null && placeholder !== void 0 ? placeholder : _options_list_strings.OptionsListStrings.control.getPlaceholder());
  return error ? /*#__PURE__*/_react.default.createElement(_control_error_component.ControlError, {
    error: error
  }) : /*#__PURE__*/_react.default.createElement(_eui.EuiFilterGroup, {
    className: (0, _classnames.default)('optionsList--filterGroup', {
      'optionsList--filterGroupSingle': controlStyle !== 'twoLine'
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiInputPopover, {
    ownFocus: true,
    input: button,
    hasArrow: false,
    repositionOnScroll: true,
    isOpen: isPopoverOpen,
    panelPaddingSize: "none",
    panelMinWidth: _constants.MIN_POPOVER_WIDTH,
    className: "optionsList__inputButtonOverride",
    initialFocus: '[data-test-subj=optionsList-control-search-input]',
    closePopover: () => optionsList.dispatch.setPopoverOpen(false),
    panelClassName: "optionsList__popoverOverride",
    panelProps: {
      'aria-label': _options_list_strings.OptionsListStrings.popover.getAriaLabel(fieldName)
    }
  }, /*#__PURE__*/_react.default.createElement(_options_list_popover.OptionsListPopover, {
    isLoading: debouncedLoading,
    updateSearchString: updateSearchString,
    loadMoreSuggestions: loadMoreSuggestions
  })));
};
exports.OptionsListControl = OptionsListControl;