"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getDataControlFieldRegistry = void 0;
var _lodash = require("lodash");
var _services = require("../../services");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const getDataControlFieldRegistry = (0, _lodash.memoize)(async dataView => {
  return await loadFieldRegistryFromDataView(dataView);
}, dataView => [dataView.id, JSON.stringify(dataView.fields.getAll())].join('|'));
exports.getDataControlFieldRegistry = getDataControlFieldRegistry;
const loadFieldRegistryFromDataView = async dataView => {
  const {
    controls: {
      getControlTypes,
      getControlFactory
    }
  } = _services.pluginServices.getServices();
  const controlFactories = getControlTypes().map(controlType => getControlFactory(controlType));
  const fieldRegistry = {};
  return new Promise(resolve => {
    for (const field of dataView.fields.getAll()) {
      const compatibleControlTypes = [];
      for (const factory of controlFactories) {
        if (factory.isFieldCompatible && factory.isFieldCompatible(field)) {
          compatibleControlTypes.push(factory.type);
        }
      }
      if (compatibleControlTypes.length > 0) {
        fieldRegistry[field.name] = {
          field,
          compatibleControlTypes
        };
      }
    }
    resolve(fieldRegistry);
  });
};