"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RpcClient = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _common = require("../../common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

class RpcClient {
  constructor(http) {
    (0, _defineProperty2.default)(this, "sendMessage", async (name, input) => {
      try {
        const response = await this.http.post(`${_common.API_ENDPOINT}/${name}`, {
          body: JSON.stringify(input)
        });
        return response.result;
      } catch (e) {
        // eslint-disable-next-line no-console
        console.log(`Content management client error: ${e.body.message}`);
        throw e;
      }
    });
    this.http = http;
  }
  get(input) {
    return this.sendMessage('get', input).then(r => r.result);
  }
  bulkGet(input) {
    return this.sendMessage('bulkGet', input).then(r => r.result);
  }
  create(input) {
    return this.sendMessage('create', input).then(r => r.result);
  }
  update(input) {
    return this.sendMessage('update', input).then(r => r.result);
  }
  delete(input) {
    return this.sendMessage('delete', input).then(r => r.result);
  }
  search(input) {
    return this.sendMessage('search', input).then(r => r.result);
  }
  mSearch(input) {
    return this.sendMessage('mSearch', input).then(r => r.result);
  }
}
exports.RpcClient = RpcClient;