"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.versionSchema = exports.procedureNames = void 0;
var _configSchema = require("@kbn/config-schema");
var _utils = require("@kbn/object-versioning/lib/utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const procedureNames = ['get', 'bulkGet', 'create', 'update', 'delete', 'search', 'mSearch'];
exports.procedureNames = procedureNames;
const versionSchema = _configSchema.schema.number({
  validate: value => {
    const {
      result
    } = (0, _utils.validateVersion)(value);
    if (!result) {
      return 'must be an integer';
    }
  }
});
exports.versionSchema = versionSchema;