"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SpecDefinitionsService = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _lodash = _interopRequireWildcard(require("lodash"));
var _globby = _interopRequireDefault(require("globby"));
var _path = require("path");
var _normalizePath = _interopRequireDefault(require("normalize-path"));
var _fs = require("fs");
var _constants = require("../../common/constants");
var _lib = require("../lib");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

class SpecDefinitionsService {
  constructor() {
    (0, _defineProperty2.default)(this, "name", 'es');
    (0, _defineProperty2.default)(this, "globalRules", {});
    (0, _defineProperty2.default)(this, "endpoints", {});
    (0, _defineProperty2.default)(this, "hasLoadedDefinitions", false);
  }
  addGlobalAutocompleteRules(parentNode, rules) {
    this.globalRules[parentNode] = rules;
  }
  addEndpointDescription(endpoint, description = {}) {
    let copiedDescription = {};
    if (this.endpoints[endpoint]) {
      copiedDescription = {
        ...this.endpoints[endpoint]
      };
    }
    let urlParamsDef;
    _lodash.default.each(description.patterns || [], function (p) {
      if (p.indexOf('{index}') >= 0) {
        urlParamsDef = urlParamsDef || {};
        urlParamsDef.ignore_unavailable = '__flag__';
        urlParamsDef.allow_no_indices = '__flag__';
        urlParamsDef.expand_wildcards = ['open', 'closed'];
      }
    });
    if (urlParamsDef) {
      description.url_params = _lodash.default.assign(description.url_params || {}, copiedDescription.url_params);
      _lodash.default.defaults(description.url_params, urlParamsDef);
    }
    _lodash.default.assign(copiedDescription, description);
    _lodash.default.defaults(copiedDescription, {
      id: endpoint,
      patterns: [endpoint],
      methods: ['GET']
    });
    this.endpoints[endpoint] = copiedDescription;
  }
  asJson() {
    return {
      name: this.name,
      globals: this.globalRules,
      endpoints: this.endpoints
    };
  }
  start({
    endpointsAvailability
  }) {
    if (!this.hasLoadedDefinitions) {
      this.loadJsonDefinitions(endpointsAvailability);
      this.loadJSDefinitions();
      this.hasLoadedDefinitions = true;
    } else {
      throw new Error('Service has already started!');
    }
  }
  loadJSONDefinitionsFiles() {
    // we need to normalize paths otherwise they don't work on windows, see https://github.com/elastic/kibana/issues/151032
    const generatedFiles = _globby.default.sync((0, _normalizePath.default)((0, _path.join)(_constants.AUTOCOMPLETE_DEFINITIONS_FOLDER, _constants.GENERATED_SUBFOLDER, '*.json')));
    const overrideFiles = _globby.default.sync((0, _normalizePath.default)((0, _path.join)(_constants.AUTOCOMPLETE_DEFINITIONS_FOLDER, _constants.OVERRIDES_SUBFOLDER, '*.json')));
    const manualFiles = _globby.default.sync((0, _normalizePath.default)((0, _path.join)(_constants.AUTOCOMPLETE_DEFINITIONS_FOLDER, _constants.MANUAL_SUBFOLDER, '*.json')));

    // definitions files contain only 1 definition per endpoint name { "endpointName": { endpointDescription }}
    // all endpoints need to be merged into 1 object with endpoint names as keys and endpoint definitions as values
    const jsonDefinitions = {};
    generatedFiles.forEach(file => {
      const overrideFile = overrideFiles.find(f => (0, _path.basename)(f) === (0, _path.basename)(file));
      const loadedDefinition = JSON.parse((0, _fs.readFileSync)(file, 'utf8'));
      if (overrideFile) {
        (0, _lodash.merge)(loadedDefinition, JSON.parse((0, _fs.readFileSync)(overrideFile, 'utf8')));
      }
      this.addToJsonDefinitions({
        loadedDefinition,
        jsonDefinitions
      });
    });

    // add manual definitions
    manualFiles.forEach(file => {
      const loadedDefinition = JSON.parse((0, _fs.readFileSync)(file, 'utf8'));
      this.addToJsonDefinitions({
        loadedDefinition,
        jsonDefinitions
      });
    });
    return jsonDefinitions;
  }
  addToJsonDefinitions({
    loadedDefinition,
    jsonDefinitions
  }) {
    // iterate over EndpointDefinition for a safe and easy access to the only property in this object
    Object.entries(loadedDefinition).forEach(([endpointName, endpointDescription]) => {
      // endpoints should all have unique names, but in case that happens unintentionally
      // don't silently overwrite the definition but create a new unique endpoint name
      if (jsonDefinitions[endpointName]) {
        // add time to create a unique key
        jsonDefinitions[`${endpointName}${Date.now()}`] = endpointDescription;
      } else {
        jsonDefinitions[endpointName] = endpointDescription;
      }
    });
    return jsonDefinitions;
  }
  loadJsonDefinitions(endpointsAvailability) {
    const result = this.loadJSONDefinitionsFiles();
    Object.keys(result).forEach(endpoint => {
      const description = result[endpoint];
      const addEndpoint =
      // If the 'availability' property doesn't exist, display the endpoint by default
      !description.availability || endpointsAvailability === 'stack' && description.availability.stack || endpointsAvailability === 'serverless' && description.availability.serverless;
      if (addEndpoint) {
        this.addEndpointDescription(endpoint, description);
      }
    });
  }
  loadJSDefinitions() {
    _lib.jsSpecLoaders.forEach(addJsSpec => addJsSpec(this));
  }
}
exports.SpecDefinitionsService = SpecDefinitionsService;