"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createReadOnlyAceEditor = createReadOnlyAceEditor;
var _lodash = _interopRequireDefault(require("lodash"));
var _brace = _interopRequireDefault(require("brace"));
var _output = require("./mode/output");
var _smart_resize = _interopRequireDefault(require("./smart_resize"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/**
 * Note: using read-only ace editor leaks the Ace editor API - use this as sparingly as possible or
 * create an interface for it so that we don't rely directly on vendor APIs.
 */
function createReadOnlyAceEditor(element) {
  const output = _brace.default.acequire('ace/ace').edit(element);
  const outputMode = new _output.Mode();
  output.$blockScrolling = Infinity;
  output.resize = (0, _smart_resize.default)(output);
  output.update = (val, mode, cb) => {
    if (typeof mode === 'function') {
      cb = mode;
      mode = void 0;
    }
    const session = output.getSession();
    const currentMode = val ? mode || outputMode : 'ace/mode/text';

    // @ts-ignore
    // ignore ts error here due to type definition mistake in brace for setMode(mode: string): void;
    // this method accepts string or SyntaxMode which is an object. See https://github.com/ajaxorg/ace/blob/13dc911dbc0ea31ca343d5744b3f472767458fc3/ace.d.ts#L467
    session.setMode(currentMode);
    session.setValue(val);
    if (typeof cb === 'function') {
      setTimeout(cb);
    }
  };
  output.append = (val, foldPrevious, cb) => {
    if (typeof foldPrevious === 'function') {
      cb = foldPrevious;
      foldPrevious = true;
    }
    if (_lodash.default.isUndefined(foldPrevious)) {
      foldPrevious = true;
    }
    const session = output.getSession();
    const lastLine = session.getLength();
    if (foldPrevious) {
      output.moveCursorTo(Math.max(0, lastLine - 1), 0);
    }
    session.insert({
      row: lastLine,
      column: 0
    }, '\n' + val);
    output.moveCursorTo(lastLine + 1, 0);
    if (typeof cb === 'function') {
      setTimeout(cb);
    }
  };
  (function setupSession(session) {
    session.setMode('ace/mode/text');
    session.setFoldStyle('markbeginend');
    session.setTabSize(2);
    session.setUseWrapMode(true);
  })(output.getSession());
  output.setShowPrintMargin(false);
  output.setReadOnly(true);
  return output;
}