"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SchemaTypesError = void 0;
var _ = require(".");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

class SchemaTypesError extends _.SchemaTypeError {
  constructor(error, path, errors) {
    super(error, path);

    // Set the prototype explicitly, see:
    // https://github.com/Microsoft/TypeScript/wiki/Breaking-Changes#extending-built-ins-like-error-array-and-map-may-no-longer-work
    this.errors = errors;
    Object.setPrototypeOf(this, SchemaTypesError.prototype);
  }
}
exports.SchemaTypesError = SchemaTypesError;