"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Match = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _common = require("@kbn/data-plugin/common");
var _uiTheme = require("@kbn/ui-theme");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const Match = ({
  index,
  rule,
  updateValue,
  editable,
  options,
  specialTokens,
  assignmentValuesCounter
}) => {
  var _assignmentValuesCoun;
  const duplicateWarning = _i18n.i18n.translate('coloring.colorMapping.assignments.duplicateCategoryWarning', {
    defaultMessage: 'This category has already been assigned a different color. Only the first matching assignment will be used.'
  });
  const selectedOptions = rule.type === 'auto' ? [] : typeof rule.values === 'string' ? [{
    label: rule.values,
    value: rule.values,
    append: ((_assignmentValuesCoun = assignmentValuesCounter.get(rule.values)) !== null && _assignmentValuesCoun !== void 0 ? _assignmentValuesCoun : 0) > 1 ? /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      position: "bottom",
      content: duplicateWarning
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      size: "s",
      type: "warning",
      color: _uiTheme.euiThemeVars.euiColorWarningText
    })) : undefined
  }] : rule.values.map(value => {
    var _assignmentValuesCoun2;
    const ruleValues = Array.isArray(value) ? value : [value];
    return {
      label: ruleValues.map(v => {
        var _specialTokens$get;
        return (_specialTokens$get = specialTokens.get(v)) !== null && _specialTokens$get !== void 0 ? _specialTokens$get : v;
      }).join(_common.MULTI_FIELD_KEY_SEPARATOR),
      value,
      append: ((_assignmentValuesCoun2 = assignmentValuesCounter.get(value)) !== null && _assignmentValuesCoun2 !== void 0 ? _assignmentValuesCoun2 : 0) > 1 ? /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
        position: "bottom",
        content: duplicateWarning
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
        size: "s",
        type: "warning",
        color: _uiTheme.euiThemeVars.euiColorWarningText
      })) : undefined
    };
  });
  const convertedOptions = options.map(value => {
    const ruleValues = Array.isArray(value) ? value : [value];
    return {
      label: ruleValues.map(v => {
        var _specialTokens$get2;
        return (_specialTokens$get2 = specialTokens.get(v)) !== null && _specialTokens$get2 !== void 0 ? _specialTokens$get2 : v;
      }).join(_common.MULTI_FIELD_KEY_SEPARATOR),
      value
    };
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    style: {
      minWidth: 1,
      width: 1
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    "data-test-subj": `lns-colorMapping-assignmentsItem${index}`,
    isDisabled: !editable,
    fullWidth: true,
    "aria-label": _i18n.i18n.translate('coloring.colorMapping.assignments.autoAssignedTermAriaLabel', {
      defaultMessage: "This color will be automatically assigned to the first term that doesn't match with all the other assignments"
    }),
    placeholder: _i18n.i18n.translate('coloring.colorMapping.assignments.autoAssignedTermPlaceholder', {
      defaultMessage: 'Auto assigned'
    }),
    options: convertedOptions,
    selectedOptions: selectedOptions,
    onChange: changedOptions => {
      updateValue(changedOptions.reduce((acc, option) => {
        if (option.value !== undefined) {
          acc.push(option.value);
        }
        return acc;
      }, []));
    },
    onCreateOption: label => {
      if (selectedOptions.findIndex(option => option.label.toLowerCase() === label) === -1) {
        updateValue([...selectedOptions, {
          label,
          value: label
        }].map(d => d.value));
      }
    },
    isClearable: false,
    compressed: true
  }));
};
exports.Match = Match;