"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.VulnerabilityTablePanel = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react2 = require("@emotion/react");
var _vulnerability_table_panel = require("./vulnerability_table_panel.config");
var _chart_panel = require("../../components/chart_panel");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const VulnerabilityTablePanel = ({
  items,
  columns,
  tableType,
  onViewVulnerabilitiesClick
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const {
    title
  } = _vulnerability_table_panel.vulnerabilityDashboardTableContent[tableType];
  return /*#__PURE__*/_react.default.createElement(_chart_panel.ChartPanel, {
    title: title
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    "justify-content": "space-between"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
    className: "vulnerabilityTable",
    css: (0, _react2.css)`
              & .euiTableHeaderCell {
                border-bottom: ${euiTheme.border.width.thick} solid ${euiTheme.colors.darkestShade};
              }
            `,
    items: items,
    columns: columns
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    css: (0, _react2.css)`
              width: fit-content;
            `,
    iconType: "search",
    onClick: onViewVulnerabilitiesClick,
    size: "s"
  }, _i18n.i18n.translate('xpack.csp.vulnerabilityTable.panel.buttonText', {
    defaultMessage: 'View all vulnerabilities'
  })))));
};
exports.VulnerabilityTablePanel = VulnerabilityTablePanel;