"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.VulnerabilityStatistics = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _vuln_counter_card = require("../../components/vuln_counter_card");
var _constants = require("../../../common/constants");
var _use_vulnerability_dashboard_api = require("../../common/api/use_vulnerability_dashboard_api");
var _use_navigate_findings = require("../../common/hooks/use_navigate_findings");
var _compact_formatted_number = require("../../components/compact_formatted_number");
var _get_vulnerability_colors = require("../../common/utils/get_vulnerability_colors");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const VulnerabilityStatistics = () => {
  const navToVulnerabilities = (0, _use_navigate_findings.useNavigateVulnerabilities)();
  const getVulnerabilityDashboard = (0, _use_vulnerability_dashboard_api.useVulnerabilityDashboardApi)();
  const stats = (0, _react.useMemo)(() => {
    var _getVulnerabilityDash, _getVulnerabilityDash2, _getVulnerabilityDash3, _getVulnerabilityDash4, _getVulnerabilityDash5;
    return [{
      id: 'critical-count-stat',
      title: /*#__PURE__*/_react.default.createElement(_compact_formatted_number.CompactFormattedNumber, {
        number: (_getVulnerabilityDash = getVulnerabilityDashboard.data) === null || _getVulnerabilityDash === void 0 ? void 0 : _getVulnerabilityDash.cnvmStatistics.criticalCount
      }),
      description: /*#__PURE__*/_react.default.createElement(_eui.EuiHealth, {
        color: (0, _get_vulnerability_colors.getSeverityStatusColor)(_constants.VULNERABILITIES_SEVERITY.CRITICAL),
        textSize: 'xs'
      }, _i18n.i18n.translate('xpack.csp.cnvmDashboard.statistics.criticalTitle', {
        defaultMessage: 'Critical'
      })),
      onClick: () => {
        navToVulnerabilities({
          'vulnerability.severity': _constants.VULNERABILITIES_SEVERITY.CRITICAL
        });
      }
    }, {
      id: 'high-count-stat',
      title: /*#__PURE__*/_react.default.createElement(_compact_formatted_number.CompactFormattedNumber, {
        number: (_getVulnerabilityDash2 = getVulnerabilityDashboard.data) === null || _getVulnerabilityDash2 === void 0 ? void 0 : _getVulnerabilityDash2.cnvmStatistics.highCount
      }),
      description: /*#__PURE__*/_react.default.createElement(_eui.EuiHealth, {
        color: (0, _get_vulnerability_colors.getSeverityStatusColor)(_constants.VULNERABILITIES_SEVERITY.HIGH),
        textSize: 'xs'
      }, _i18n.i18n.translate('xpack.csp.cnvmDashboard.statistics.highTitle', {
        defaultMessage: 'High'
      })),
      onClick: () => {
        navToVulnerabilities({
          'vulnerability.severity': _constants.VULNERABILITIES_SEVERITY.HIGH
        });
      }
    }, {
      id: 'medium-count-stat',
      title: /*#__PURE__*/_react.default.createElement(_compact_formatted_number.CompactFormattedNumber, {
        number: (_getVulnerabilityDash3 = getVulnerabilityDashboard.data) === null || _getVulnerabilityDash3 === void 0 ? void 0 : _getVulnerabilityDash3.cnvmStatistics.mediumCount
      }),
      description: /*#__PURE__*/_react.default.createElement(_eui.EuiHealth, {
        color: (0, _get_vulnerability_colors.getSeverityStatusColor)(_constants.VULNERABILITIES_SEVERITY.MEDIUM),
        textSize: 'xs'
      }, _i18n.i18n.translate('xpack.csp.cnvmDashboard.statistics.mediumTitle', {
        defaultMessage: 'Medium'
      })),
      onClick: () => {
        navToVulnerabilities({
          'vulnerability.severity': _constants.VULNERABILITIES_SEVERITY.MEDIUM
        });
      }
    }, {
      id: 'cloud-regions-stat',
      title: /*#__PURE__*/_react.default.createElement(_compact_formatted_number.CompactFormattedNumber, {
        number: (_getVulnerabilityDash4 = getVulnerabilityDashboard.data) === null || _getVulnerabilityDash4 === void 0 ? void 0 : _getVulnerabilityDash4.cnvmStatistics.cloudRegions
      }),
      description: _i18n.i18n.translate('xpack.csp.cnvmDashboard.statistics.cloudRegionTitle', {
        defaultMessage: 'Cloud Regions'
      })
    }, {
      id: 'assets-scanned-stat',
      title: /*#__PURE__*/_react.default.createElement(_compact_formatted_number.CompactFormattedNumber, {
        number: (_getVulnerabilityDash5 = getVulnerabilityDashboard.data) === null || _getVulnerabilityDash5 === void 0 ? void 0 : _getVulnerabilityDash5.cnvmStatistics.resourcesScanned
      }),
      description: _i18n.i18n.translate('xpack.csp.cnvmDashboard.statistics.resourcesScannedTitle', {
        defaultMessage: 'Resources Scanned'
      })
    }];
  }, [getVulnerabilityDashboard.data, navToVulnerabilities]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, stats.map(stat => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    key: stat.id
  }, /*#__PURE__*/_react.default.createElement(_vuln_counter_card.VulnCounterCard, stat))));
};
exports.VulnerabilityStatistics = VulnerabilityStatistics;