"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useFindCspRuleTemplates = void 0;
var _reactQuery = require("@tanstack/react-query");
var _use_kibana = require("../../common/hooks/use_kibana");
var _constants = require("../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useFindCspRuleTemplates = ({
  search,
  page,
  perPage,
  section
}, packagePolicyId) => {
  const {
    http
  } = (0, _use_kibana.useKibana)().services;
  return (0, _reactQuery.useQuery)([_constants.CSP_RULE_TEMPLATE_SAVED_OBJECT_TYPE, {
    section,
    search,
    page,
    perPage,
    packagePolicyId
  }], () => {
    return http.get(_constants.FIND_CSP_RULE_TEMPLATE_ROUTE_PATH, {
      query: {
        packagePolicyId,
        page,
        perPage,
        search,
        section
      },
      version: _constants.FIND_CSP_RULE_TEMPLATE_API_CURRENT_VERSION
    });
  });
};
exports.useFindCspRuleTemplates = useFindCspRuleTemplates;