"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RulesContainer = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _reactRouterDom = require("react-router-dom");
var _helpers = require("../../../common/utils/helpers");
var _rules_table = require("./rules_table");
var _rules_table_header = require("./rules_table_header");
var _use_csp_rules = require("./use_csp_rules");
var TEST_SUBJECTS = _interopRequireWildcard(require("./test_subjects"));
var _rules_flyout = require("./rules_flyout");
var _constants = require("../../common/constants");
var _use_page_size = require("../../common/hooks/use_page_size");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getRulesPageData = ({
  status,
  data,
  error
}, query) => {
  const rules = (data === null || data === void 0 ? void 0 : data.items) || [];
  const page = getPage(rules, query);
  return {
    loading: status === 'loading',
    error: error ? (0, _helpers.extractErrorMessage)(error) : undefined,
    all_rules: rules,
    rules_map: new Map(rules.map(rule => [rule.metadata.id, rule])),
    rules_page: page,
    total: (data === null || data === void 0 ? void 0 : data.total) || 0
  };
};
const getPage = (data, {
  page,
  perPage
}) => data.slice(page * perPage, (page + 1) * perPage);
const MAX_ITEMS_PER_PAGE = 10000;
const RulesContainer = () => {
  const params = (0, _reactRouterDom.useParams)();
  const [selectedRuleId, setSelectedRuleId] = (0, _react.useState)(null);
  const {
    pageSize,
    setPageSize
  } = (0, _use_page_size.usePageSize)(_constants.LOCAL_STORAGE_PAGE_SIZE_RULES_KEY);
  const [rulesQuery, setRulesQuery] = (0, _react.useState)({
    section: undefined,
    search: '',
    page: 0,
    perPage: pageSize || 10
  });
  const {
    data,
    status,
    error
  } = (0, _use_csp_rules.useFindCspRuleTemplates)({
    section: rulesQuery.section,
    search: rulesQuery.search,
    page: 1,
    perPage: MAX_ITEMS_PER_PAGE
  }, params.packagePolicyId);
  const rulesPageData = (0, _react.useMemo)(() => getRulesPageData({
    data,
    error,
    status
  }, rulesQuery), [data, error, status, rulesQuery]);

  // We need to make this call again without the filters. this way the section list is always full
  const allRules = (0, _use_csp_rules.useFindCspRuleTemplates)({
    page: 1,
    perPage: MAX_ITEMS_PER_PAGE
  }, params.packagePolicyId);
  const sectionList = (0, _react.useMemo)(() => {
    var _allRules$data;
    return (_allRules$data = allRules.data) === null || _allRules$data === void 0 ? void 0 : _allRules$data.items.map(rule => rule.metadata.section);
  }, [allRules.data]);
  const cleanedSectionList = [...new Set(sectionList)];
  return /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": TEST_SUBJECTS.CSP_RULES_CONTAINER
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: false,
    hasShadow: false
  }, /*#__PURE__*/_react.default.createElement(_rules_table_header.RulesTableHeader, {
    onSectionChange: value => setRulesQuery(currentQuery => ({
      ...currentQuery,
      section: value
    })),
    sectionSelectOptions: cleanedSectionList,
    search: value => setRulesQuery(currentQuery => ({
      ...currentQuery,
      search: value
    })),
    searchValue: rulesQuery.search || '',
    totalRulesCount: rulesPageData.all_rules.length,
    pageSize: rulesPageData.rules_page.length,
    isSearching: status === 'loading'
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_rules_table.RulesTable, {
    rules_page: rulesPageData.rules_page,
    total: rulesPageData.total,
    error: rulesPageData.error,
    loading: rulesPageData.loading,
    perPage: pageSize || rulesQuery.perPage,
    page: rulesQuery.page,
    setPagination: paginationQuery => {
      setPageSize(paginationQuery.perPage);
      setRulesQuery(currentQuery => ({
        ...currentQuery,
        ...paginationQuery
      }));
    },
    setSelectedRuleId: setSelectedRuleId,
    selectedRuleId: selectedRuleId
  })), selectedRuleId && /*#__PURE__*/_react.default.createElement(_rules_flyout.RuleFlyout, {
    rule: rulesPageData.rules_map.get(selectedRuleId),
    onClose: () => setSelectedRuleId(null)
  }));
};
exports.RulesContainer = RulesContainer;