"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FindingsSearchBar = void 0;
var _react = _interopRequireWildcard(require("react"));
var _react2 = require("@emotion/react");
var _eui = require("@elastic/eui");
var _public = require("@kbn/kibana-react-plugin/public");
var _i18n = require("@kbn/i18n");
var _security_solution_context = require("../../../application/security_solution_context");
var _common = require("../../../../common");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const FindingsSearchBar = ({
  dataView,
  loading,
  setQuery,
  placeholder = _i18n.i18n.translate('xpack.csp.findings.searchBar.searchPlaceholder', {
    defaultMessage: 'Search findings (eg. rule.section : "API Server" )'
  })
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const {
    unifiedSearch: {
      ui: {
        SearchBar
      }
    }
  } = (0, _public.useKibana)().services;
  const securitySolutionContext = (0, _react.useContext)(_security_solution_context.SecuritySolutionContext);
  let searchBarNode = /*#__PURE__*/_react.default.createElement("div", {
    css: getContainerStyle(euiTheme)
  }, /*#__PURE__*/_react.default.createElement(SearchBar, {
    appName: _common.PLUGIN_NAME,
    showFilterBar: true,
    showQueryInput: true,
    showDatePicker: false,
    saveQueryMenuVisibility: "hidden",
    isLoading: loading,
    indexPatterns: [dataView],
    onQuerySubmit: setQuery,
    onFiltersUpdated: value => setQuery({
      filters: value
    }),
    placeholder: placeholder
  }));
  if (securitySolutionContext) {
    const FiltersGlobal = securitySolutionContext.getFiltersGlobalComponent();
    searchBarNode = /*#__PURE__*/_react.default.createElement(FiltersGlobal, null, searchBarNode);
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, searchBarNode);
};
exports.FindingsSearchBar = FindingsSearchBar;
const getContainerStyle = theme => (0, _react2.css)`
  border-bottom: ${theme.border.thin};
  background-color: ${theme.colors.body};
  padding: ${theme.size.base};
`;