"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FindingsDetectionRuleCounter = void 0;
var _react = _interopRequireDefault(require("react"));
var _detection_rule_counter = require("../../../components/detection_rule_counter");
var _create_detection_rule_from_finding = require("../utils/create_detection_rule_from_finding");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const FindingsDetectionRuleCounter = ({
  finding
}) => {
  const createMisconfigurationRuleFn = async http => await (0, _create_detection_rule_from_finding.createDetectionRuleFromFinding)(http, finding);
  return /*#__PURE__*/_react.default.createElement(_detection_rule_counter.DetectionRuleCounter, {
    tags: (0, _create_detection_rule_from_finding.getFindingsDetectionRuleSearchTags)(finding),
    createRuleFn: createMisconfigurationRuleFn
  });
};
exports.FindingsDetectionRuleCounter = FindingsDetectionRuleCounter;