"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getDefaultTab = exports.ComplianceDashboard = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _test_subjects = require("../../components/test_subjects");
var _use_csp_integration_link = require("../../common/navigation/use_csp_integration_link");
var _cloud_posture_page_title = require("../../components/cloud_posture_page_title");
var _cloud_posture_page = require("../../components/cloud_posture_page");
var _test_subjects2 = require("./test_subjects");
var _use_stats_api = require("../../common/api/use_stats_api");
var _use_setup_status_api = require("../../common/api/use_setup_status_api");
var _no_findings_states = require("../../components/no_findings_states");
var _summary_section = require("./dashboard_sections/summary_section");
var _benchmarks_section = require("./dashboard_sections/benchmarks_section");
var _constants = require("../../../common/constants");
var _constants2 = require("../../common/navigation/constants");
var _constants3 = require("../../common/constants");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const POSTURE_TYPE_CSPM = _constants.CSPM_POLICY_TEMPLATE;
const POSTURE_TYPE_KSPM = _constants.KSPM_POLICY_TEMPLATE;
const noDataOptions = {
  kspm: {
    testId: _cloud_posture_page.KSPM_INTEGRATION_NOT_INSTALLED_TEST_SUBJECT,
    docsLink: _constants2.cspIntegrationDocsNavigation.kspm.overviewPath,
    actionTitle: _i18n.i18n.translate('xpack.csp.cloudPosturePage.kspmIntegration.packageNotInstalled.buttonLabel', {
      defaultMessage: 'Add a KSPM integration'
    }),
    actionDescription: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.csp.cloudPosturePage.kspmIntegration.packageNotInstalled.description",
      defaultMessage: "Use our {integrationFullName} (KSPM) integration to detect security misconfigurations in your Kubernetes clusters.",
      values: {
        integrationFullName: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          href: _constants2.cspIntegrationDocsNavigation.kspm.overviewPath,
          target: "_blank"
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.csp.cloudPosturePage.kspmIntegration.packageNotInstalled.integrationNameLabel",
          defaultMessage: "Kubernetes Security Posture Management"
        }))
      }
    })
  },
  cspm: {
    testId: _cloud_posture_page.CSPM_INTEGRATION_NOT_INSTALLED_TEST_SUBJECT,
    // TODO: CIS AWS - replace link or create the docs
    docsLink: _constants2.cspIntegrationDocsNavigation.cspm.overviewPath,
    actionTitle: _i18n.i18n.translate('xpack.csp.cloudPosturePage.cspmIntegration.packageNotInstalled.buttonLabel', {
      defaultMessage: 'Add a CSPM integration'
    }),
    actionDescription: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.csp.cloudPosturePage.cspmIntegration.packageNotInstalled.description",
      defaultMessage: "Use our {integrationFullName} (CSPM) integration to detect security misconfigurations in your cloud infrastructure.",
      values: {
        integrationFullName: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          href: _constants2.cspIntegrationDocsNavigation.cspm.overviewPath,
          target: "_blank"
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.csp.cloudPosturePage.cspmIntegration.packageNotInstalled.integrationNameLabel",
          defaultMessage: "Cloud Security Posture Management"
        }))
      }
    })
  }
};
const getNotInstalledConfig = (policyTemplate, actionHref) => {
  const policyTemplateNoDataConfig = noDataOptions[policyTemplate];
  return {
    pageTitle: _i18n.i18n.translate('xpack.csp.cloudPosturePage.packageNotInstalled.pageTitle', {
      defaultMessage: 'Install Integration to get started'
    }),
    docsLink: policyTemplateNoDataConfig.docsLink,
    actionHref,
    actionTitle: policyTemplateNoDataConfig.actionTitle,
    actionDescription: policyTemplateNoDataConfig.actionDescription,
    testId: policyTemplateNoDataConfig.testId
  };
};
const KIBANA_HEADERS_HEIGHT = 265;
const IntegrationPostureDashboard = ({
  complianceData,
  notInstalledConfig,
  isIntegrationInstalled,
  dashboardType
}) => {
  const noFindings = !complianceData || complianceData.stats.totalFindings === 0;

  // integration is not installed, and there are no findings for this integration
  if (noFindings && !isIntegrationInstalled) {
    return /*#__PURE__*/_react.default.createElement(_cloud_posture_page.CspNoDataPage, notInstalledConfig);
  }

  // integration is installed, but there are no findings for this integration
  if (noFindings && isIntegrationInstalled) {
    return (
      /*#__PURE__*/
      // height is calculated for the screen height minus the kibana header, page title, and tabs
      _react.default.createElement("div", {
        style: {
          height: `calc(100vh - ${KIBANA_HEADERS_HEIGHT}px)`,
          display: 'flex',
          justifyContent: 'center'
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
        "data-test-subj": _test_subjects.NO_FINDINGS_STATUS_TEST_SUBJ.NO_FINDINGS,
        color: "plain",
        icon: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
          type: "logoSecurity",
          size: "xl"
        }),
        title: /*#__PURE__*/_react.default.createElement("h2", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.csp.integrationDashboard.noFindings.promptTitle",
          defaultMessage: "Findings Evaluation Status"
        })),
        body: /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.csp.integrationDashboard.noFindingsPrompt.promptDescription",
          defaultMessage: "Waiting for data to be collected and indexed. If this process is taking longer than expected then please reach out our support"
        }))
      }))
    );
  }

  // there are findings, displays dashboard even if integration is not installed
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_summary_section.SummarySection, {
    complianceData: complianceData,
    dashboardType: dashboardType
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_benchmarks_section.BenchmarksSection, {
    complianceData: complianceData,
    dashboardType: dashboardType
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null));
};
const getDefaultTab = (pluginStatus, cspmStats, kspmStats) => {
  var _pluginStatus$cspm, _pluginStatus$kspm;
  const cspmTotalFindings = cspmStats === null || cspmStats === void 0 ? void 0 : cspmStats.stats.totalFindings;
  const kspmTotalFindings = kspmStats === null || kspmStats === void 0 ? void 0 : kspmStats.stats.totalFindings;
  const installedPolicyTemplatesCspm = pluginStatus === null || pluginStatus === void 0 ? void 0 : (_pluginStatus$cspm = pluginStatus.cspm) === null || _pluginStatus$cspm === void 0 ? void 0 : _pluginStatus$cspm.status;
  const installedPolicyTemplatesKspm = pluginStatus === null || pluginStatus === void 0 ? void 0 : (_pluginStatus$kspm = pluginStatus.kspm) === null || _pluginStatus$kspm === void 0 ? void 0 : _pluginStatus$kspm.status;
  let preferredDashboard = POSTURE_TYPE_CSPM;

  // cspm has findings
  if (!!cspmTotalFindings) {
    preferredDashboard = POSTURE_TYPE_CSPM;
  }
  // kspm has findings
  else if (!!kspmTotalFindings) {
    preferredDashboard = POSTURE_TYPE_KSPM;
  }
  // cspm is installed
  else if (installedPolicyTemplatesCspm !== 'unprivileged' && installedPolicyTemplatesCspm !== 'not-installed') {
    preferredDashboard = POSTURE_TYPE_CSPM;
  }
  // kspm is installed
  else if (installedPolicyTemplatesKspm !== 'unprivileged' && installedPolicyTemplatesKspm !== 'not-installed') {
    preferredDashboard = POSTURE_TYPE_KSPM;
  }
  return preferredDashboard;
};
exports.getDefaultTab = getDefaultTab;
const determineDashboardDataRefetchInterval = data => {
  if ((data === null || data === void 0 ? void 0 : data.stats.totalFindings) === 0) {
    return _constants3.NO_FINDINGS_STATUS_REFRESH_INTERVAL_MS;
  }
  return false;
};
const TabContent = ({
  posturetype
}) => {
  var _getSetupStatus$postu;
  const {
    data: getSetupStatus
  } = (0, _use_setup_status_api.useCspSetupStatusApi)({
    refetchInterval: data => {
      var _data$posturetype;
      if ((data === null || data === void 0 ? void 0 : (_data$posturetype = data[posturetype]) === null || _data$posturetype === void 0 ? void 0 : _data$posturetype.status) === 'indexed') {
        return false;
      }
      return _constants3.NO_FINDINGS_STATUS_REFRESH_INTERVAL_MS;
    }
  });
  const isCloudSecurityPostureInstalled = !!(getSetupStatus !== null && getSetupStatus !== void 0 && getSetupStatus.installedPackageVersion);
  const getCspmDashboardData = (0, _use_stats_api.useCspmStatsApi)({
    enabled: isCloudSecurityPostureInstalled && posturetype === POSTURE_TYPE_CSPM,
    refetchInterval: determineDashboardDataRefetchInterval
  });
  const getKspmDashboardData = (0, _use_stats_api.useKspmStatsApi)({
    enabled: isCloudSecurityPostureInstalled && posturetype === POSTURE_TYPE_KSPM,
    refetchInterval: determineDashboardDataRefetchInterval
  });
  const setupStatus = getSetupStatus === null || getSetupStatus === void 0 ? void 0 : (_getSetupStatus$postu = getSetupStatus[posturetype]) === null || _getSetupStatus$postu === void 0 ? void 0 : _getSetupStatus$postu.status;
  const isStatusManagedInDashboard = setupStatus === 'indexed' || setupStatus === 'not-installed';
  const shouldRenderNoFindings = !isCloudSecurityPostureInstalled || !isStatusManagedInDashboard;
  const cspmIntegrationLink = (0, _use_csp_integration_link.useCspIntegrationLink)(_constants.CSPM_POLICY_TEMPLATE);
  const kspmIntegrationLink = (0, _use_csp_integration_link.useCspIntegrationLink)(_constants.KSPM_POLICY_TEMPLATE);
  let integrationLink;
  let dataTestSubj;
  let policyTemplate;
  let getDashboardData;
  switch (posturetype) {
    case POSTURE_TYPE_CSPM:
      integrationLink = cspmIntegrationLink;
      dataTestSubj = _test_subjects2.CLOUD_DASHBOARD_CONTAINER;
      policyTemplate = _constants.CSPM_POLICY_TEMPLATE;
      getDashboardData = getCspmDashboardData;
      break;
    case POSTURE_TYPE_KSPM:
      integrationLink = kspmIntegrationLink;
      dataTestSubj = _test_subjects2.KUBERNETES_DASHBOARD_CONTAINER;
      policyTemplate = _constants.KSPM_POLICY_TEMPLATE;
      getDashboardData = getKspmDashboardData;
      break;
  }
  if (shouldRenderNoFindings) {
    return /*#__PURE__*/_react.default.createElement(_no_findings_states.NoFindingsStates, {
      posturetype: posturetype
    });
  }
  return /*#__PURE__*/_react.default.createElement(_cloud_posture_page.CloudPosturePage, {
    query: getDashboardData
  }, /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": dataTestSubj
  }, /*#__PURE__*/_react.default.createElement(IntegrationPostureDashboard, {
    dashboardType: policyTemplate,
    complianceData: getDashboardData.data,
    notInstalledConfig: getNotInstalledConfig(policyTemplate, integrationLink),
    isIntegrationInstalled: setupStatus !== 'not-installed'
  })));
};
const ComplianceDashboard = () => {
  var _getCspmDashboardData, _getKspmDashboardData, _getSetupStatus$cspm, _getSetupStatus$kspm, _tabs$find;
  const [selectedTab, setSelectedTab] = (0, _react.useState)(POSTURE_TYPE_CSPM);
  const [hasUserSelectedTab, setHasUserSelectedTab] = (0, _react.useState)(false);
  const {
    data: getSetupStatus
  } = (0, _use_setup_status_api.useCspSetupStatusApi)();
  const isCloudSecurityPostureInstalled = !!(getSetupStatus !== null && getSetupStatus !== void 0 && getSetupStatus.installedPackageVersion);
  const getCspmDashboardData = (0, _use_stats_api.useCspmStatsApi)({
    enabled: isCloudSecurityPostureInstalled
  });
  const getKspmDashboardData = (0, _use_stats_api.useKspmStatsApi)({
    enabled: isCloudSecurityPostureInstalled
  });
  (0, _react.useEffect)(() => {
    if (hasUserSelectedTab) {
      return;
    }
    const preferredDashboard = getDefaultTab(getSetupStatus, getCspmDashboardData.data, getKspmDashboardData.data);
    setSelectedTab(preferredDashboard);
  }, [getCspmDashboardData.data, (_getCspmDashboardData = getCspmDashboardData.data) === null || _getCspmDashboardData === void 0 ? void 0 : _getCspmDashboardData.stats.totalFindings, getKspmDashboardData.data, (_getKspmDashboardData = getKspmDashboardData.data) === null || _getKspmDashboardData === void 0 ? void 0 : _getKspmDashboardData.stats.totalFindings, getSetupStatus, getSetupStatus === null || getSetupStatus === void 0 ? void 0 : (_getSetupStatus$cspm = getSetupStatus.cspm) === null || _getSetupStatus$cspm === void 0 ? void 0 : _getSetupStatus$cspm.status, getSetupStatus === null || getSetupStatus === void 0 ? void 0 : (_getSetupStatus$kspm = getSetupStatus.kspm) === null || _getSetupStatus$kspm === void 0 ? void 0 : _getSetupStatus$kspm.status, hasUserSelectedTab]);
  const tabs = (0, _react.useMemo)(() => isCloudSecurityPostureInstalled ? [{
    label: _i18n.i18n.translate('xpack.csp.dashboardTabs.cloudTab.tabTitle', {
      defaultMessage: 'Cloud'
    }),
    'data-test-subj': _test_subjects2.CLOUD_DASHBOARD_TAB,
    isSelected: selectedTab === POSTURE_TYPE_CSPM,
    onClick: () => {
      setSelectedTab(POSTURE_TYPE_CSPM);
      setHasUserSelectedTab(true);
    },
    content: /*#__PURE__*/_react.default.createElement(TabContent, {
      posturetype: POSTURE_TYPE_CSPM
    })
  }, {
    label: _i18n.i18n.translate('xpack.csp.dashboardTabs.kubernetesTab.tabTitle', {
      defaultMessage: 'Kubernetes'
    }),
    'data-test-subj': _test_subjects2.KUBERNETES_DASHBOARD_TAB,
    isSelected: selectedTab === POSTURE_TYPE_KSPM,
    onClick: () => {
      setSelectedTab(POSTURE_TYPE_KSPM);
      setHasUserSelectedTab(true);
    },
    content: /*#__PURE__*/_react.default.createElement(TabContent, {
      posturetype: POSTURE_TYPE_KSPM
    })
  }] : [], [selectedTab, isCloudSecurityPostureInstalled]);
  return /*#__PURE__*/_react.default.createElement(_cloud_posture_page.CloudPosturePage, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPageHeader, {
    "data-test-subj": _test_subjects2.CLOUD_POSTURE_DASHBOARD_PAGE_HEADER,
    bottomBorder: true,
    pageTitle: /*#__PURE__*/_react.default.createElement(_cloud_posture_page_title.CloudPosturePageTitle, {
      title: _i18n.i18n.translate('xpack.csp.dashboard.cspPageTemplate.pageTitle', {
        defaultMessage: 'Cloud Security Posture'
      })
    }),
    tabs: tabs.map(({
      content,
      ...rest
    }) => rest)
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": _test_subjects2.DASHBOARD_CONTAINER,
    css: (0, _react2.css)`
          margin-left: auto;
          margin-right: auto;
          height: 100%;
        `
  }, (_tabs$find = tabs.find(t => t.isSelected)) === null || _tabs$find === void 0 ? void 0 : _tabs$find.content, !isCloudSecurityPostureInstalled && /*#__PURE__*/_react.default.createElement(_no_findings_states.NoFindingsStates, {
    posturetype: POSTURE_TYPE_CSPM
  })));
};
exports.ComplianceDashboard = ComplianceDashboard;