"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useCspBenchmarkIntegrations = void 0;
var _reactQuery = require("@tanstack/react-query");
var _constants = require("../../../common/constants");
var _use_kibana = require("../../common/hooks/use_kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const QUERY_KEY = 'csp_benchmark_integrations';
const useCspBenchmarkIntegrations = ({
  name,
  perPage,
  page,
  sortField,
  sortOrder
}) => {
  const {
    http
  } = (0, _use_kibana.useKibana)().services;
  const query = {
    package_policy_name: name,
    per_page: perPage,
    page,
    sort_field: sortField,
    sort_order: sortOrder
  };
  return (0, _reactQuery.useQuery)([QUERY_KEY, query], () => http.get(_constants.BENCHMARKS_ROUTE_PATH, {
    query,
    version: _constants.BENCHMARKS_API_CURRENT_VERSION
  }), {
    keepPreviousData: true
  });
};
exports.useCspBenchmarkIntegrations = useCspBenchmarkIntegrations;