"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.showErrorToast = void 0;
var _i18n = require("@kbn/i18n");
var _helpers = require("../../../common/utils/helpers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SEARCH_FAILED_TEXT = _i18n.i18n.translate('xpack.csp.findings.findingsErrorToast.searchFailedTitle', {
  defaultMessage: 'Search failed'
});
const showErrorToast = (toasts, error) => {
  if (error instanceof Error) toasts.addError(error, {
    title: SEARCH_FAILED_TEXT
  });else toasts.addDanger((0, _helpers.extractErrorMessage)(error, SEARCH_FAILED_TEXT));
};
exports.showErrorToast = showErrorToast;