"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerCloudDefendUsageCollector = registerCloudDefendUsageCollector;
var _indices_stats_collector = require("./indices_stats_collector");
var _pods_stats_collector = require("./pods_stats_collector");
var _schema = require("./schema");
var _accounts_stats_collector = require("./accounts_stats_collector");
var _installation_stats_collector = require("./installation_stats_collector");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function registerCloudDefendUsageCollector(logger, coreServices, usageCollection) {
  // usageCollection is an optional dependency, so make sure to return if it is not registered
  if (!usageCollection) {
    logger.debug('Usage collection disabled');
    return;
  }

  // Create usage collector
  const cloudDefendUsageCollector = usageCollection.makeUsageCollector({
    type: 'cloud_defend',
    isReady: async () => {
      await coreServices;
      return true;
    },
    fetch: async collectorFetchContext => {
      logger.debug('Starting cloud_defend usage collection');
      const [indicesStats, accountsStats, podsStats, installationStats] = await Promise.all([(0, _indices_stats_collector.getIndicesStats)(collectorFetchContext.esClient, collectorFetchContext.soClient, coreServices, logger), (0, _accounts_stats_collector.getAccountsStats)(collectorFetchContext.esClient, logger), (0, _pods_stats_collector.getPodsStats)(collectorFetchContext.esClient, logger), (0, _installation_stats_collector.getInstallationStats)(collectorFetchContext.esClient, collectorFetchContext.soClient, coreServices, logger)]).catch(err => {
        logger.error(err);
        return err;
      });
      return {
        indices: indicesStats,
        accounts_stats: accountsStats,
        pods_stats: podsStats,
        installation_stats: installationStats
      };
    },
    schema: _schema.cloudDefendUsageSchema
  });

  // Register usage collector
  usageCollection.registerCollector(cloudDefendUsageCollector);
}