"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CloudDefendPlugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _public = require("@kbn/kibana-react-plugin/public");
var _sharedUxLinkRedirectApp = require("@kbn/shared-ux-link-redirect-app");
var _react = _interopRequireWildcard(require("react"));
var _constants = require("../common/constants");
var _loading_state = require("./components/loading_state");
var _setup_context = require("./application/setup_context");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; } /*
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * or more contributor license agreements. Licensed under the Elastic License
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * 2.0; you may not use this file except in compliance with the Elastic License
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * 2.0.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      */
const LazyPolicyReplaceDefineStepExtension = /*#__PURE__*/(0, _react.lazy)(() => Promise.resolve().then(() => _interopRequireWildcard(require('./components/fleet_extensions/package_policy_replace_define_step_extension'))));
const LazyCustomAssets = /*#__PURE__*/(0, _react.lazy)(() => Promise.resolve().then(() => _interopRequireWildcard(require('./components/fleet_extensions/custom_assets_extension'))));
const RouterLazy = /*#__PURE__*/(0, _react.lazy)(() => Promise.resolve().then(() => _interopRequireWildcard(require('./application/router'))));
const Router = props => /*#__PURE__*/_react.default.createElement(_react.Suspense, {
  fallback: /*#__PURE__*/_react.default.createElement(_loading_state.LoadingState, null)
}, /*#__PURE__*/_react.default.createElement(RouterLazy, props));
class CloudDefendPlugin {
  constructor() {
    (0, _defineProperty2.default)(this, "isCloudEnabled", void 0);
  }
  setup(core, plugins) {
    this.isCloudEnabled = plugins.cloud.isCloudEnabled;

    // Return methods that should be available to other plugins
    return {};
  }
  start(core, plugins) {
    plugins.fleet.registerExtension({
      package: _constants.INTEGRATION_PACKAGE_NAME,
      view: 'package-policy-replace-define-step',
      Component: LazyPolicyReplaceDefineStepExtension
    });
    plugins.fleet.registerExtension({
      package: _constants.INTEGRATION_PACKAGE_NAME,
      view: 'package-detail-assets',
      Component: LazyCustomAssets
    });
    const CloudDefendRouter = props => /*#__PURE__*/_react.default.createElement(_public.KibanaContextProvider, {
      services: {
        ...core,
        ...plugins
      }
    }, /*#__PURE__*/_react.default.createElement(_sharedUxLinkRedirectApp.RedirectAppLinks, {
      coreStart: core
    }, /*#__PURE__*/_react.default.createElement("div", {
      style: {
        width: '100%',
        height: '100%'
      }
    }, /*#__PURE__*/_react.default.createElement(_setup_context.SetupContext.Provider, {
      value: {
        isCloudEnabled: this.isCloudEnabled
      }
    }, /*#__PURE__*/_react.default.createElement(Router, props)))));
    return {
      getCloudDefendRouter: () => CloudDefendRouter
    };
  }
  stop() {}
}
exports.CloudDefendPlugin = CloudDefendPlugin;