"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ChatExperimentSwitcher = ChatExperimentSwitcher;
var _react = _interopRequireDefault(require("react"));
var _useObservable = _interopRequireDefault(require("react-use/lib/useObservable"));
var _chat_header_menu_item = require("../chat_header_menu_item");
var _chat_floating_bubble = require("../chat_floating_bubble");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const BUBBLE_ALLOWED_LOCATIONS = ['app/home#/getting_started', 'app/enterprise_search/overview', 'app/observability/overview', 'app/security/get_started', 'app/integrations'];
function ChatExperimentSwitcher(props) {
  const location = (0, _useObservable.default)(props.location$);
  if (!location) return null;
  if (props.variant === 'bubble') {
    if (BUBBLE_ALLOWED_LOCATIONS.some(loc => location.includes(loc))) {
      return /*#__PURE__*/_react.default.createElement(_chat_floating_bubble.Chat, null);
    } else {
      return null;
    }
  } else {
    return /*#__PURE__*/_react.default.createElement(_chat_header_menu_item.ChatHeaderMenuItem, null);
  }
}