"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WhenIdle = void 0;
exports.whenIdle = whenIdle;
var _react = _interopRequireDefault(require("react"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function whenIdle(doWork) {
  const requestIdleCallback = window.requestIdleCallback || window.setTimeout;
  if (document.readyState === 'complete') {
    requestIdleCallback(() => doWork());
  } else {
    window.addEventListener('load', () => {
      requestIdleCallback(() => doWork());
    });
  }
}

/**
 * Postpone rendering of children until the page is loaded and browser is idle.
 */
const WhenIdle = ({
  children
}) => {
  const [idleFired, setIdleFired] = _react.default.useState(false);
  _react.default.useEffect(() => {
    whenIdle(() => {
      setIdleFired(true);
    });
  }, []);
  return idleFired ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, children) : null;
};
exports.WhenIdle = WhenIdle;