"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EmptyPlaceholder = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _react2 = require("@emotion/react");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const style = (0, _react2.css)`
  height: 100%;
  display: flex;
  flex-direction: column;
  align-items: center;
  justify-content: center;
`;
const EmptyPlaceholder = ({
  icon,
  iconColor = 'subdued',
  message = /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "charts.noDataLabel",
    defaultMessage: "No results found"
  }),
  dataTestSubj = 'emptyPlaceholder',
  className,
  renderComplete
}) => {
  (0, _react.useEffect)(() => {
    renderComplete === null || renderComplete === void 0 ? void 0 : renderComplete();
  }, [renderComplete]);
  return /*#__PURE__*/_react.default.createElement("div", {
    className: className,
    css: style
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    "data-test-subj": dataTestSubj,
    textAlign: "center",
    color: "subdued",
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: icon,
    color: iconColor,
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement("p", null, message)));
};
exports.EmptyPlaceholder = EmptyPlaceholder;