"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getHeatmapColors = getHeatmapColors;
var _lodash = require("lodash");
var _color_maps = require("./color_maps");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

function interpolateLinearly(x, values) {
  // Split values into four lists
  const xValues = [];
  const rValues = [];
  const gValues = [];
  const bValues = [];
  values.forEach(value => {
    xValues.push(value[0]);
    rValues.push(value[1][0]);
    gValues.push(value[1][1]);
    bValues.push(value[1][2]);
  });
  let i = 1;
  while (xValues[i] < x) i++;
  const width = Math.abs(xValues[i - 1] - xValues[i]);
  const scalingFactor = (x - xValues[i - 1]) / width;
  // Get the new color values though interpolation
  const r = rValues[i - 1] + scalingFactor * (rValues[i] - rValues[i - 1]);
  const g = gValues[i - 1] + scalingFactor * (gValues[i] - gValues[i - 1]);
  const b = bValues[i - 1] + scalingFactor * (bValues[i] - bValues[i - 1]);
  return [(0, _lodash.clamp)(r, 0, 1), (0, _lodash.clamp)(g, 0, 1), (0, _lodash.clamp)(b, 0, 1)];
}
function getHeatmapColors(value, colorSchemaName) {
  var _vislibColorMaps$colo;
  if (!(0, _lodash.isNumber)(value) || value < 0 || value > 1) {
    throw new Error('heatmap_color expects a number from 0 to 1 as first parameter');
  }
  const colorSchema = (_vislibColorMaps$colo = _color_maps.vislibColorMaps[colorSchemaName]) === null || _vislibColorMaps$colo === void 0 ? void 0 : _vislibColorMaps$colo.value;
  if (!colorSchema) {
    throw new Error('invalid colorSchemaName provided');
  }
  const color = interpolateLinearly(value, colorSchema);
  const r = Math.round(255 * color[0]);
  const g = Math.round(255 * color[1]);
  const b = Math.round(255 * color[2]);
  return `rgb(${r},${g},${b})`;
}