"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getCaseUserActionStatsRoute = void 0;
var _configSchema = require("@kbn/config-schema");
var _constants = require("../../../../common/constants");
var _error = require("../../../common/error");
var _create_cases_route = require("../create_cases_route");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getCaseUserActionStatsRoute = (0, _create_cases_route.createCasesRoute)({
  method: 'get',
  path: _constants.INTERNAL_GET_CASE_USER_ACTIONS_STATS_URL,
  params: {
    params: _configSchema.schema.object({
      case_id: _configSchema.schema.string()
    })
  },
  handler: async ({
    context,
    request,
    response
  }) => {
    try {
      const casesContext = await context.cases;
      const casesClient = await casesContext.getCasesClient();
      const caseId = request.params.case_id;
      const res = await casesClient.userActions.stats({
        caseId
      });
      return response.ok({
        body: res
      });
    } catch (error) {
      throw (0, _error.createCaseError)({
        message: `Failed to retrieve stats in route case id: ${request.params.case_id}: ${error}`,
        error
      });
    }
  }
});
exports.getCaseUserActionStatsRoute = getCaseUserActionStatsRoute;