"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.casesCustomFields = void 0;
var _domain = require("../../common/types/domain");
var _text = require("./text");
var _toggle = require("./toggle");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const mapping = {
  [_domain.CustomFieldTypes.TEXT]: (0, _text.getCasesTextCustomField)(),
  [_domain.CustomFieldTypes.TOGGLE]: (0, _toggle.getCasesToggleCustomField)()
};
const casesCustomFields = {
  get: type => {
    var _mapping$type;
    return (_mapping$type = mapping[type]) !== null && _mapping$type !== void 0 ? _mapping$type : null;
  }
};
exports.casesCustomFields = casesCustomFields;