"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WriteOperations = exports.ReadOperations = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
/**
 * The tenses for describing the action performed by a API route
 */
/**
 * Read operations for the cases APIs.
 */
let ReadOperations;
/**
 * Write operations for the cases APIs.
 */
exports.ReadOperations = ReadOperations;
(function (ReadOperations) {
  ReadOperations["GetCase"] = "getCase";
  ReadOperations["ResolveCase"] = "resolveCase";
  ReadOperations["FindCases"] = "findCases";
  ReadOperations["BulkGetCases"] = "bulkGetCases";
  ReadOperations["GetCaseIDsByAlertID"] = "getCaseIDsByAlertID";
  ReadOperations["GetCaseStatuses"] = "getCaseStatuses";
  ReadOperations["GetComment"] = "getComment";
  ReadOperations["BulkGetAttachments"] = "bulkGetAttachments";
  ReadOperations["GetAllComments"] = "getAllComments";
  ReadOperations["FindComments"] = "findComments";
  ReadOperations["GetTags"] = "getTags";
  ReadOperations["GetCategories"] = "getCategories";
  ReadOperations["GetReporters"] = "getReporters";
  ReadOperations["FindConfigurations"] = "findConfigurations";
  ReadOperations["FindUserActions"] = "findUserActions";
  ReadOperations["GetUserActions"] = "getUserActions";
  ReadOperations["GetConnectors"] = "getConnectors";
  ReadOperations["GetAlertsAttachedToCase"] = "getAlertsAttachedToCase";
  ReadOperations["GetAttachmentMetrics"] = "getAttachmentMetrics";
  ReadOperations["GetCaseMetrics"] = "getCaseMetrics";
  ReadOperations["GetCasesMetrics"] = "getCasesMetrics";
  ReadOperations["GetUserActionMetrics"] = "getUserActionMetrics";
  ReadOperations["GetUserActionUsers"] = "getUserActionUsers";
})(ReadOperations || (exports.ReadOperations = ReadOperations = {}));
let WriteOperations;
/**
 * Defines the structure for a case API route.
 */
exports.WriteOperations = WriteOperations;
(function (WriteOperations) {
  WriteOperations["CreateCase"] = "createCase";
  WriteOperations["DeleteCase"] = "deleteCase";
  WriteOperations["UpdateCase"] = "updateCase";
  WriteOperations["PushCase"] = "pushCase";
  WriteOperations["CreateComment"] = "createComment";
  WriteOperations["BulkCreateAttachments"] = "bulkCreateAttachments";
  WriteOperations["DeleteAllComments"] = "deleteAllComments";
  WriteOperations["DeleteComment"] = "deleteComment";
  WriteOperations["UpdateComment"] = "updateComment";
  WriteOperations["CreateConfiguration"] = "createConfiguration";
  WriteOperations["UpdateConfiguration"] = "updateConfiguration";
})(WriteOperations || (exports.WriteOperations = WriteOperations = {}));
/**
 * Describes an entity with the necessary fields to identify if the user is authorized to interact with the saved object
 * returned from some find query.
 */
/**
 * Function callback for making sure the found saved objects are of the authorized owner
 */
/**
 * Defines the helper methods and necessary information for authorizing the find API's request.
 */