"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useGetCasesMetrics = void 0;
var _reactQuery = require("@tanstack/react-query");
var _api = require("../../common/types/api");
var _use_cases_context = require("../components/cases_context/use_cases_context");
var i18n = _interopRequireWildcard(require("./translations"));
var _kibana = require("../common/lib/kibana");
var _api2 = require("../api");
var _use_cases_toast = require("../common/use_cases_toast");
var _constants = require("./constants");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useGetCasesMetrics = () => {
  const http = (0, _kibana.useHttp)();
  const {
    owner
  } = (0, _use_cases_context.useCasesContext)();
  const {
    showErrorToast
  } = (0, _use_cases_toast.useCasesToast)();
  return (0, _reactQuery.useQuery)(_constants.casesQueriesKeys.casesMetrics(), ({
    signal
  }) => (0, _api2.getCasesMetrics)({
    http,
    query: {
      owner,
      features: [_api.CaseMetricsFeature.MTTR]
    },
    signal
  }), {
    onError: error => {
      showErrorToast(error, {
        title: i18n.ERROR_TITLE
      });
    }
  });
};
exports.useGetCasesMetrics = useGetCasesMetrics;