"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
var _exportNames = {
  ERROR_TITLE: true,
  ERROR_CREATING_CASE: true,
  ERROR_DELETING: true,
  ERROR_DELETING_FILE: true,
  ERROR_UPDATING: true,
  UPDATED_CASE: true,
  UPDATED_CASES: true,
  SUCCESS_SEND_TO_EXTERNAL_SERVICE: true,
  SYNC_CASE: true,
  STATUS_CHANGED_TOASTER_TEXT: true,
  FILE_DELETE_SUCCESS: true,
  CATEGORIES_ERROR_TITLE: true
};
exports.UPDATED_CASES = exports.UPDATED_CASE = exports.SYNC_CASE = exports.SUCCESS_SEND_TO_EXTERNAL_SERVICE = exports.STATUS_CHANGED_TOASTER_TEXT = exports.FILE_DELETE_SUCCESS = exports.ERROR_UPDATING = exports.ERROR_TITLE = exports.ERROR_DELETING_FILE = exports.ERROR_DELETING = exports.ERROR_CREATING_CASE = exports.CATEGORIES_ERROR_TITLE = void 0;
var _i18n = require("@kbn/i18n");
var _translations = require("../common/translations");
Object.keys(_translations).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (Object.prototype.hasOwnProperty.call(_exportNames, key)) return;
  if (key in exports && exports[key] === _translations[key]) return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function () {
      return _translations[key];
    }
  });
});
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ERROR_TITLE = _i18n.i18n.translate('xpack.cases.containers.errorTitle', {
  defaultMessage: 'Error fetching data'
});
exports.ERROR_TITLE = ERROR_TITLE;
const ERROR_CREATING_CASE = _i18n.i18n.translate('xpack.cases.containers.errorCreatingCaseTitle', {
  defaultMessage: 'Error creating case'
});
exports.ERROR_CREATING_CASE = ERROR_CREATING_CASE;
const ERROR_DELETING = _i18n.i18n.translate('xpack.cases.containers.errorDeletingTitle', {
  defaultMessage: 'Error deleting data'
});
exports.ERROR_DELETING = ERROR_DELETING;
const ERROR_DELETING_FILE = _i18n.i18n.translate('xpack.cases.containers.errorDeletingFile', {
  defaultMessage: 'Error deleting file'
});
exports.ERROR_DELETING_FILE = ERROR_DELETING_FILE;
const ERROR_UPDATING = _i18n.i18n.translate('xpack.cases.containers.errorUpdatingTitle', {
  defaultMessage: 'Error updating data'
});
exports.ERROR_UPDATING = ERROR_UPDATING;
const UPDATED_CASE = caseTitle => _i18n.i18n.translate('xpack.cases.containers.updatedCase', {
  values: {
    caseTitle
  },
  defaultMessage: 'Updated "{caseTitle}"'
});
exports.UPDATED_CASE = UPDATED_CASE;
const UPDATED_CASES = _i18n.i18n.translate('xpack.cases.containers.updatedCases', {
  defaultMessage: 'Updated cases'
});
exports.UPDATED_CASES = UPDATED_CASES;
const SUCCESS_SEND_TO_EXTERNAL_SERVICE = serviceName => _i18n.i18n.translate('xpack.cases.containers.pushToExternalService', {
  values: {
    serviceName
  },
  defaultMessage: 'Successfully sent to { serviceName }'
});
exports.SUCCESS_SEND_TO_EXTERNAL_SERVICE = SUCCESS_SEND_TO_EXTERNAL_SERVICE;
const SYNC_CASE = caseTitle => _i18n.i18n.translate('xpack.cases.containers.syncCase', {
  values: {
    caseTitle
  },
  defaultMessage: 'Alerts in "{caseTitle}" have been synced'
});
exports.SYNC_CASE = SYNC_CASE;
const STATUS_CHANGED_TOASTER_TEXT = _i18n.i18n.translate('xpack.cases.containers.statusChangeToasterText', {
  defaultMessage: 'Updated the statuses of attached alerts.'
});
exports.STATUS_CHANGED_TOASTER_TEXT = STATUS_CHANGED_TOASTER_TEXT;
const FILE_DELETE_SUCCESS = _i18n.i18n.translate('xpack.cases.containers.deleteSuccess', {
  defaultMessage: 'File deleted successfully'
});
exports.FILE_DELETE_SUCCESS = FILE_DELETE_SUCCESS;
const CATEGORIES_ERROR_TITLE = _i18n.i18n.translate('xpack.cases.containers.categoriesErrorTitle', {
  defaultMessage: 'Error fetching categories'
});
exports.CATEGORIES_ERROR_TITLE = CATEGORIES_ERROR_TITLE;