"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isLensEmbeddable = exports.hasInput = exports.getLensCaseAttachment = void 0;
var _public = require("@kbn/lens-plugin/public");
var _visualizations = require("../../../../common/constants/visualizations");
var _domain = require("../../../../common/types/domain");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const isLensEmbeddable = embeddable => {
  return embeddable.type === _public.LENS_EMBEDDABLE_TYPE;
};
exports.isLensEmbeddable = isLensEmbeddable;
const hasInput = embeddable => {
  const {
    timeRange
  } = embeddable.getInput();
  const attributes = embeddable.getFullAttributes();
  return attributes != null && timeRange != null;
};
exports.hasInput = hasInput;
const getLensCaseAttachment = ({
  timeRange,
  attributes
}) => ({
  persistableStateAttachmentState: {
    attributes,
    timeRange
  },
  persistableStateAttachmentTypeId: _visualizations.LENS_ATTACHMENT_TYPE,
  type: _domain.AttachmentType.persistableState
});
exports.getLensCaseAttachment = getLensCaseAttachment;