"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UserToolTip = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _user_avatar = require("./user_avatar");
var _display_name = require("./display_name");
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const UserFullInformation = /*#__PURE__*/_react.default.memo(({
  userInfo
}) => {
  var _userInfo$user;
  if (userInfo !== null && userInfo !== void 0 && (_userInfo$user = userInfo.user) !== null && _userInfo$user !== void 0 && _userInfo$user.full_name) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s",
      className: "eui-textBreakWord"
    }, /*#__PURE__*/_react.default.createElement("strong", {
      "data-test-subj": "user-profile-tooltip-full-name"
    }, userInfo.user.full_name));
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    className: "eui-textBreakWord",
    "data-test-subj": "user-profile-tooltip-single-name"
  }, /*#__PURE__*/_react.default.createElement("strong", null, getNameOrMissingText(userInfo === null || userInfo === void 0 ? void 0 : userInfo.user)));
});
const getNameOrMissingText = user => {
  if (!user) {
    return i18n.MISSING_PROFILE;
  }
  return (0, _display_name.getName)(user);
};
UserFullInformation.displayName = 'UserFullInformation';
const UserToolTipAvatar = ({
  userInfo
}) => /*#__PURE__*/_react.default.createElement(_user_avatar.CaseUserAvatar, {
  size: 'm',
  userInfo: userInfo
});
UserToolTipAvatar.displayName = 'UserToolTipAvatar';
const UserFullRepresentationComponent = ({
  userInfo
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    "data-test-subj": "user-profile-tooltip-avatar"
  }, /*#__PURE__*/_react.default.createElement(UserToolTipAvatar, {
    userInfo: userInfo
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: 'column',
    gutterSize: "none"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(UserFullInformation, {
    userInfo: userInfo
  })), (userInfo === null || userInfo === void 0 ? void 0 : userInfo.user) && displayEmail(userInfo) && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    className: "eui-textBreakWord",
    "data-test-subj": "user-profile-tooltip-email"
  }, userInfo.user.email)))));
};
UserFullRepresentationComponent.displayName = 'UserFullRepresentation';
const displayEmail = userInfo => {
  var _userInfo$user2, _userInfo$user3;
  return (userInfo === null || userInfo === void 0 ? void 0 : (_userInfo$user2 = userInfo.user) === null || _userInfo$user2 === void 0 ? void 0 : _userInfo$user2.full_name) && (userInfo === null || userInfo === void 0 ? void 0 : (_userInfo$user3 = userInfo.user) === null || _userInfo$user3 === void 0 ? void 0 : _userInfo$user3.email);
};
const UserToolTipComponent = ({
  children,
  userInfo
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    display: "inlineBlock",
    position: "top",
    content: /*#__PURE__*/_react.default.createElement(UserFullRepresentationComponent, {
      userInfo: userInfo
    }),
    "data-test-subj": "user-profile-tooltip"
  }, children);
};
UserToolTipComponent.displayName = 'UserToolTip';
const UserToolTip = /*#__PURE__*/_react.default.memo(UserToolTipComponent);
exports.UserToolTip = UserToolTip;