"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createCommonUpdateUserActionBuilder = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _domain = require("../../../common/types/domain");
var _timestamp = require("./timestamp");
var _copy_link = require("./copy_link");
var _move_to_reference = require("./move_to_reference");
var _hoverable_user_with_avatar_resolver = require("../user_profiles/hoverable_user_with_avatar_resolver");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const showMoveToReference = (action, commentId) => action === _domain.UserActionActions.update && commentId != null;
const CommentListActions = /*#__PURE__*/_react.default.memo(({
  userAction,
  handleOutlineComment
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
  responsive: false
}, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false
}, /*#__PURE__*/_react.default.createElement(_copy_link.UserActionCopyLink, {
  id: userAction.id
})), showMoveToReference(userAction.action, userAction.commentId) && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false
}, /*#__PURE__*/_react.default.createElement(_move_to_reference.UserActionMoveToReference, {
  id: userAction.commentId,
  outlineComment: handleOutlineComment
}))));
CommentListActions.displayName = 'CommentListActions';
const createCommonUpdateUserActionBuilder = ({
  userProfiles,
  userAction,
  label,
  icon,
  handleOutlineComment
}) => {
  return {
    build: () => [{
      username: /*#__PURE__*/_react.default.createElement(_hoverable_user_with_avatar_resolver.HoverableUserWithAvatarResolver, {
        user: userAction.createdBy,
        userProfiles: userProfiles
      }),
      event: label,
      'data-test-subj': `${userAction.type}-${userAction.action}-action-${userAction.id}`,
      timestamp: /*#__PURE__*/_react.default.createElement(_timestamp.UserActionTimestamp, {
        createdAt: userAction.createdAt
      }),
      timelineAvatar: icon,
      actions: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        responsive: false
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false
      }, /*#__PURE__*/_react.default.createElement(_copy_link.UserActionCopyLink, {
        id: userAction.id
      })), showMoveToReference(userAction.action, userAction.commentId) && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false
      }, /*#__PURE__*/_react.default.createElement(_move_to_reference.UserActionMoveToReference, {
        id: userAction.commentId,
        outlineComment: handleOutlineComment
      })))
    }]
  };
};
exports.createCommonUpdateUserActionBuilder = createCommonUpdateUserActionBuilder;