"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.severities = void 0;
var _uiTheme = require("@kbn/ui-theme");
var _domain = require("../../../common/types/domain");
var _translations = require("./translations");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const severities = {
  [_domain.CaseSeverity.LOW]: {
    color: _uiTheme.euiLightVars.euiColorVis0,
    label: _translations.LOW
  },
  [_domain.CaseSeverity.MEDIUM]: {
    color: _uiTheme.euiLightVars.euiColorVis5,
    label: _translations.MEDIUM
  },
  [_domain.CaseSeverity.HIGH]: {
    color: _uiTheme.euiLightVars.euiColorVis7,
    label: _translations.HIGH
  },
  [_domain.CaseSeverity.CRITICAL]: {
    color: _uiTheme.euiLightVars.euiColorVis9,
    label: _translations.CRITICAL
  }
};
exports.severities = severities;