"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PropertyActions = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _types = require("../../client/attachment_framework/types");
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ComponentId = 'property-actions';
const PropertyActionButton = /*#__PURE__*/_react.default.memo(({
  disabled = false,
  onClick,
  iconType,
  label,
  color,
  customDataTestSubj
}) => {
  const dataTestSubjPrepend = makeDataTestSubjPrepend(customDataTestSubj);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "aria-label": label,
    color: color ? color : 'text',
    "data-test-subj": `${dataTestSubjPrepend}-${iconType}`,
    iconSide: "left",
    iconType: iconType,
    isDisabled: disabled,
    onClick: onClick
  }, label);
});
PropertyActionButton.displayName = 'PropertyActionButton';
const PropertyActions = /*#__PURE__*/_react.default.memo(({
  propertyActions,
  customDataTestSubj
}) => {
  const [showActions, setShowActions] = (0, _react.useState)(false);
  const onButtonClick = (0, _react.useCallback)(() => {
    setShowActions(prevShowActions => !prevShowActions);
  }, []);
  const onClosePopover = (0, _react.useCallback)(cb => {
    setShowActions(false);
    if (cb != null) {
      cb();
    }
  }, []);
  const dataTestSubjPrepend = makeDataTestSubjPrepend(customDataTestSubj);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    anchorPosition: "downRight",
    "data-test-subj": dataTestSubjPrepend,
    ownFocus: true,
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      "data-test-subj": `${dataTestSubjPrepend}-ellipses`,
      "aria-label": i18n.ACTIONS_ARIA,
      iconType: "boxesHorizontal",
      onClick: onButtonClick
    }),
    id: "settingsPopover",
    isOpen: showActions,
    closePopover: onClosePopover,
    repositionOnScroll: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "flexStart",
    "data-test-subj": `${dataTestSubjPrepend}-group`,
    direction: "column",
    gutterSize: "none"
  }, propertyActions.map((action, key) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    key: `${action.type}-${key}`
  }, /*#__PURE__*/_react.default.createElement("span", null, action.type === _types.AttachmentActionType.BUTTON && /*#__PURE__*/_react.default.createElement(PropertyActionButton, {
    disabled: action.disabled,
    iconType: action.iconType,
    label: action.label,
    color: action.color,
    onClick: () => onClosePopover(action.onClick),
    customDataTestSubj: customDataTestSubj
  }) || action.type === _types.AttachmentActionType.CUSTOM && /*#__PURE__*/_react.default.createElement(_react.Suspense, {
    fallback: /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, null)
  }, action.render()))))));
});
exports.PropertyActions = PropertyActions;
PropertyActions.displayName = 'PropertyActions';
const makeDataTestSubjPrepend = customDataTestSubj => {
  return customDataTestSubj == null ? ComponentId : `${ComponentId}-${customDataTestSubj}`;
};