"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ScrollableMarkdown = exports.ContentWrapper = void 0;
var _react = _interopRequireDefault(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _renderer = require("./renderer");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ContentWrapper = _styledComponents.default.div`
  padding: ${({
  theme
}) => `${theme.eui.euiSizeM} ${theme.eui.euiSizeL}`};
  text-overflow: ellipsis;
  word-break: break-word;
  display: -webkit-box;
  -webkit-box-orient: vertical;
`;
exports.ContentWrapper = ContentWrapper;
const ScrollableMarkdownRenderer = ({
  content
}) => {
  return /*#__PURE__*/_react.default.createElement(ContentWrapper, {
    className: 'eui-xScroll',
    "data-test-subj": "scrollable-markdown"
  }, /*#__PURE__*/_react.default.createElement(_renderer.MarkdownRenderer, null, content));
};
ScrollableMarkdownRenderer.displayName = 'ScrollableMarkdownRenderer';
const ScrollableMarkdown = /*#__PURE__*/_react.default.memo(ScrollableMarkdownRenderer);
exports.ScrollableMarkdown = ScrollableMarkdown;