"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FilePreview = void 0;
var _react = _interopRequireWildcard(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _eui = require("@elastic/eui");
var _sharedUxFileContext = require("@kbn/shared-ux-file-context");
var _files = require("../../../common/files");
var _use_cases_context = require("../cases_context/use_cases_context");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const StyledOverlayMask = (0, _styledComponents.default)(_eui.EuiOverlayMask)`
  padding-block-end: 0vh !important;

  img {
    max-height: 85vh;
    max-width: 85vw;
    object-fit: contain;
  }
`;
const FilePreview = ({
  closePreview,
  selectedFile
}) => {
  const {
    client: filesClient
  } = (0, _sharedUxFileContext.useFilesContext)();
  const {
    owner
  } = (0, _use_cases_context.useCasesContext)();
  (0, _react.useEffect)(() => {
    const keyboardListener = event => {
      if (event.key === _eui.keys.ESCAPE || event.code === 'Escape') {
        closePreview();
      }
    };
    window.addEventListener('keyup', keyboardListener);
    return () => {
      window.removeEventListener('keyup', keyboardListener);
    };
  }, [closePreview]);
  return /*#__PURE__*/_react.default.createElement(StyledOverlayMask, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFocusTrap, {
    onClickOutside: closePreview
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiImage, {
    alt: selectedFile.name,
    size: "original",
    src: filesClient.getDownloadHref({
      id: selectedFile.id,
      fileKind: (0, _files.constructFileKindIdByOwner)(owner[0])
    }),
    "data-test-subj": "cases-files-image-preview"
  })));
};
exports.FilePreview = FilePreview;
FilePreview.displayName = 'FilePreview';