"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EditConnector = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _fp = require("lodash/fp");
var i18n = _interopRequireWildcard(require("./translations"));
var _utils = require("../utils");
var _use_push_to_service = require("../use_push_to_service");
var _kibana = require("../../common/lib/kibana");
var _push_button = require("./push_button");
var _push_callouts = require("./push_callouts");
var _connectors_form = require("./connectors_form");
var _fields_preview_form = require("../connectors/fields_preview_form");
var _use_cases_context = require("../cases_context/use_cases_context");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/* eslint-disable complexity */

const EditConnector = /*#__PURE__*/_react.default.memo(({
  caseData,
  caseConnectors,
  supportedActionConnectors,
  isLoading,
  onSubmit
}) => {
  var _caseActionConnector$;
  const caseConnectorFields = caseData.connector.fields;
  const caseActionConnector = (0, _utils.getConnectorById)(caseData.connector.id, supportedActionConnectors);
  const isValidConnector = !!caseActionConnector;
  const [isEdit, setIsEdit] = (0, _react.useState)(false);
  const {
    actions
  } = (0, _kibana.useApplicationCapabilities)();
  const {
    permissions
  } = (0, _use_cases_context.useCasesContext)();
  const canUseConnectors = permissions.connectors && actions.read;
  const onEditClick = (0, _react.useCallback)(() => setIsEdit(true), []);
  const onCancelConnector = (0, _react.useCallback)(() => setIsEdit(false), []);
  const onSubmitConnector = (0, _react.useCallback)(connector => {
    onSubmit(connector);
    setIsEdit(false);
  }, [onSubmit]);
  const connectorWithName = {
    ...caseData.connector,
    name: (0, _fp.isEmpty)(caseActionConnector === null || caseActionConnector === void 0 ? void 0 : caseActionConnector.name) ? caseData.connector.name : (_caseActionConnector$ = caseActionConnector === null || caseActionConnector === void 0 ? void 0 : caseActionConnector.name) !== null && _caseActionConnector$ !== void 0 ? _caseActionConnector$ : ''
  };
  const {
    errorsMsg,
    needsToBePushed,
    hasBeenPushed,
    isLoading: isLoadingPushToService,
    hasPushPermissions,
    hasErrorMessages,
    hasLicenseError,
    handlePushToService
  } = (0, _use_push_to_service.usePushToService)({
    connector: connectorWithName,
    caseConnectors,
    caseId: caseData.id,
    caseStatus: caseData.status,
    isValidConnector
  });
  const disablePushButton = isLoadingPushToService || errorsMsg.length > 0 || !hasPushPermissions || !isValidConnector || !needsToBePushed;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    "data-test-subj": "sidebar-connectors"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "xs",
    justifyContent: "spaceBetween",
    responsive: false,
    "data-test-subj": "case-view-edit-connector"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    "data-test-subj": "connector-edit-header"
  }, /*#__PURE__*/_react.default.createElement("h4", null, i18n.CONNECTORS)), !isLoading && !isEdit && hasPushPermissions && canUseConnectors ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    "data-test-subj": "connector-edit",
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    "data-test-subj": "connector-edit-button",
    "aria-label": i18n.EDIT_CONNECTOR_ARIA,
    iconType: "pencil",
    onClick: onEditClick
  })) : null), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "xs"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    "data-test-subj": "edit-connectors",
    direction: "column",
    alignItems: "stretch"
  }, !isLoading && !isEdit && hasErrorMessages && canUseConnectors && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    "data-test-subj": "push-callouts"
  }, /*#__PURE__*/_react.default.createElement(_push_callouts.PushCallouts, {
    errorsMsg: errorsMsg,
    hasLicenseError: hasLicenseError,
    hasConnectors: supportedActionConnectors.length > 0,
    onEditClick: onEditClick
  })), !canUseConnectors && /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    "data-test-subj": "edit-connector-permissions-error-msg",
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("span", null, i18n.READ_ACTIONS_PERMISSIONS_ERROR_MSG)), canUseConnectors && !isEdit && /*#__PURE__*/_react.default.createElement(_fields_preview_form.ConnectorFieldsPreviewForm, {
    connector: caseActionConnector,
    fields: caseConnectorFields
  }), canUseConnectors && isEdit && /*#__PURE__*/_react.default.createElement(_connectors_form.ConnectorsForm, {
    caseData: caseData,
    caseConnectors: caseConnectors,
    supportedActionConnectors: supportedActionConnectors,
    isLoading: isLoading,
    onCancel: onCancelConnector,
    onSubmit: onSubmitConnector
  }), !hasErrorMessages && !isLoading && !isEdit && hasPushPermissions && canUseConnectors && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement("span", null, /*#__PURE__*/_react.default.createElement(_push_button.PushButton, {
    hasBeenPushed: hasBeenPushed,
    disabled: disablePushButton,
    isLoading: isLoadingPushToService,
    pushToService: handlePushToService,
    errorsMsg: errorsMsg,
    showTooltip: errorsMsg.length > 0 || !needsToBePushed || !hasPushPermissions,
    connectorName: connectorWithName.name
  }))))));
});
exports.EditConnector = EditConnector;
EditConnector.displayName = 'EditConnector';