"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CustomFields = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var i18n = _interopRequireWildcard(require("./translations"));
var _use_cases_context = require("../cases_context/use_cases_context");
var _constants = require("../../../common/constants");
var _custom_fields_list = require("./custom_fields_list");
var _experimental_badge = require("../experimental_badge/experimental_badge");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CustomFieldsComponent = ({
  disabled,
  isLoading,
  handleAddCustomField,
  handleDeleteCustomField,
  handleEditCustomField,
  customFields
}) => {
  const {
    permissions
  } = (0, _use_cases_context.useCasesContext)();
  const canAddCustomFields = permissions.create && permissions.update;
  const [error, setError] = (0, _react.useState)(false);
  const onAddCustomField = (0, _react.useCallback)(() => {
    if (customFields.length === _constants.MAX_CUSTOM_FIELDS_PER_CASE && !error) {
      setError(true);
      return;
    }
    handleAddCustomField();
    setError(false);
  }, [handleAddCustomField, setError, customFields, error]);
  const onEditCustomField = (0, _react.useCallback)(key => {
    setError(false);
    handleEditCustomField(key);
  }, [setError, handleEditCustomField]);
  if (customFields.length < _constants.MAX_CUSTOM_FIELDS_PER_CASE && error) {
    setError(false);
  }
  return canAddCustomFields ? /*#__PURE__*/_react.default.createElement(_eui.EuiDescribedFormGroup, {
    fullWidth: true,
    title: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "center",
      gutterSize: "none"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, i18n.TITLE), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_experimental_badge.ExperimentalBadge, null))),
    description: /*#__PURE__*/_react.default.createElement("p", null, i18n.DESCRIPTION),
    "data-test-subj": "custom-fields-form-group"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    paddingSize: "s",
    color: "subdued",
    hasBorder: false,
    hasShadow: false
  }, customFields.length ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_custom_fields_list.CustomFieldsList, {
    customFields: customFields,
    onDeleteCustomField: handleDeleteCustomField,
    onEditCustomField: onEditCustomField
  }), error ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "danger"
  }, i18n.MAX_CUSTOM_FIELD_LIMIT(_constants.MAX_CUSTOM_FIELDS_PER_CASE)))) : null) : null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), !customFields.length ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, i18n.NO_CUSTOM_FIELDS, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }))) : null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    isLoading: isLoading,
    isDisabled: disabled || error,
    size: "s",
    onClick: onAddCustomField,
    iconType: "plusInCircle",
    "data-test-subj": "add-custom-field"
  }, i18n.ADD_CUSTOM_FIELD))))) : null;
};
CustomFieldsComponent.displayName = 'CustomFields';
const CustomFields = /*#__PURE__*/_react.default.memo(CustomFieldsComponent);
exports.CustomFields = CustomFields;