"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _hook_form_lib = require("@kbn/es-ui-shared-plugin/static/forms/hook_form_lib");
var _components = require("@kbn/es-ui-shared-plugin/static/forms/components");
var _kibana = require("../../../common/lib/kibana");
var _use_get_incident_types = require("./use_get_incident_types");
var _use_get_severity = require("./use_get_severity");
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ResilientFieldsComponent = ({
  connector
}) => {
  const {
    http
  } = (0, _kibana.useKibana)().services;
  const {
    isLoading: isLoadingIncidentTypesData,
    isFetching: isFetchingIncidentTypesData,
    data: allIncidentTypesData
  } = (0, _use_get_incident_types.useGetIncidentTypes)({
    http,
    connector
  });
  const {
    isLoading: isLoadingSeverityData,
    isFetching: isFetchingSeverityData,
    data: severityData
  } = (0, _use_get_severity.useGetSeverity)({
    http,
    connector
  });
  const allIncidentTypes = allIncidentTypesData === null || allIncidentTypesData === void 0 ? void 0 : allIncidentTypesData.data;
  const severity = severityData === null || severityData === void 0 ? void 0 : severityData.data;
  const isLoadingIncidentTypes = isLoadingIncidentTypesData || isFetchingIncidentTypesData;
  const isLoadingSeverity = isLoadingSeverityData || isFetchingSeverityData;
  const severitySelectOptions = (0, _react.useMemo)(() => (severity !== null && severity !== void 0 ? severity : []).map(s => ({
    value: s.id.toString(),
    text: s.name
  })), [severity]);
  const incidentTypesComboBoxOptions = (0, _react.useMemo)(() => allIncidentTypes ? allIncidentTypes.map(type => ({
    label: type.name,
    value: type.id.toString()
  })) : [], [allIncidentTypes]);
  return /*#__PURE__*/_react.default.createElement("span", {
    "data-test-subj": 'connector-fields-resilient'
  }, /*#__PURE__*/_react.default.createElement(_hook_form_lib.UseField, {
    path: "fields.incidentTypes",
    config: {
      defaultValue: []
    }
  }, field => {
    var _field$value;
    const {
      isInvalid,
      errorMessage
    } = (0, _hook_form_lib.getFieldValidityAndErrorMessage)(field);
    const onChangeComboBox = changedOptions => {
      field.setValue(changedOptions.map(option => option.value));
    };
    const selectedOptions = ((_field$value = field.value) !== null && _field$value !== void 0 ? _field$value : []).map(incidentType => {
      var _find$name, _find;
      return {
        value: incidentType,
        label: (_find$name = (_find = (allIncidentTypes !== null && allIncidentTypes !== void 0 ? allIncidentTypes : []).find(type => incidentType === type.id.toString())) === null || _find === void 0 ? void 0 : _find.name) !== null && _find$name !== void 0 ? _find$name : ''
      };
    });
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      id: "indexConnectorSelectSearchBox",
      fullWidth: true,
      label: i18n.INCIDENT_TYPES_LABEL,
      isInvalid: isInvalid,
      error: errorMessage
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
      "data-test-subj": "incidentTypeComboBox",
      fullWidth: true,
      isClearable: true,
      isDisabled: isLoadingIncidentTypes,
      isLoading: isLoadingIncidentTypes,
      onChange: onChangeComboBox,
      options: incidentTypesComboBoxOptions,
      placeholder: i18n.INCIDENT_TYPES_PLACEHOLDER,
      selectedOptions: selectedOptions
    }));
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_hook_form_lib.UseField, {
    path: "fields.severityCode",
    component: _components.SelectField,
    config: {
      label: i18n.SEVERITY_LABEL
    },
    componentProps: {
      euiFieldProps: {
        'data-test-subj': 'severitySelect',
        options: severitySelectOptions,
        hasNoInitialSelection: true,
        fullWidth: true,
        disabled: isLoadingSeverity,
        isLoading: isLoadingSeverity
      }
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }));
};
exports.default = ResilientFieldsComponent;
ResilientFieldsComponent.displayName = 'ResilientFields';
// eslint-disable-next-line import/no-default-export
module.exports = exports.default;