"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.CaseViewLoading = exports.CaseView = void 0;
var _react = _interopRequireWildcard(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _eui = require("@elastic/eui");
var _use_get_case = require("../../containers/use_get_case");
var i18n = _interopRequireWildcard(require("./translations"));
var _timeline_context = require("../timeline_context");
var _does_not_exist = require("./does_not_exist");
var _kibana = require("../../common/lib/kibana");
var _use_cases_context = require("../cases_context/use_cases_context");
var _navigation = require("../../common/navigation");
var _case_view_page = require("./case_view_page");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MyEuiFlexGroup = (0, _styledComponents.default)(_eui.EuiFlexGroup)`
  height: 100%;
`;
const CaseViewLoading = () => /*#__PURE__*/_react.default.createElement(MyEuiFlexGroup, {
  gutterSize: "none",
  justifyContent: "center",
  alignItems: "center"
}, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false
}, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
  "data-test-subj": "case-view-loading",
  size: "xl"
})));
exports.CaseViewLoading = CaseViewLoading;
const CaseView = /*#__PURE__*/_react.default.memo(({
  onComponentInitialized,
  actionsNavigation,
  ruleDetailsNavigation,
  showAlertDetails,
  timelineIntegration,
  useFetchAlertData,
  refreshRef
}) => {
  const {
    spaces: spacesApi
  } = (0, _kibana.useKibana)().services;
  const {
    detailName: caseId
  } = (0, _navigation.useCaseViewParams)();
  const {
    basePath
  } = (0, _use_cases_context.useCasesContext)();
  const {
    data,
    isLoading,
    isError,
    refetch
  } = (0, _use_get_case.useGetCase)(caseId);
  (0, _react.useEffect)(() => {
    if (spacesApi && (data === null || data === void 0 ? void 0 : data.outcome) === 'aliasMatch' && data.aliasTargetId != null) {
      const newPath = `${basePath}${(0, _navigation.generateCaseViewPath)({
        detailName: data.aliasTargetId
      })}`;
      spacesApi.ui.redirectLegacyUrl({
        path: `${newPath}${window.location.search}${window.location.hash}`,
        aliasPurpose: data.aliasPurpose,
        objectNoun: i18n.CASE
      });
    }
  }, [basePath, data, spacesApi]);
  const getLegacyUrlConflictCallout = (0, _react.useCallback)(() => {
    // This function returns a callout component *if* we have encountered a "legacy URL conflict" scenario
    if (data && spacesApi && data.outcome === 'conflict' && data.aliasTargetId != null) {
      // We have resolved to one object, but another object has a legacy URL alias associated with this ID/page. We should display a
      // callout with a warning for the user, and provide a way for them to navigate to the other object.
      const otherObjectPath = `${basePath}${(0, _navigation.generateCaseViewPath)({
        detailName: data.aliasTargetId
      })}${window.location.search}${window.location.hash}`;
      return spacesApi.ui.components.getLegacyUrlConflict({
        objectNoun: i18n.CASE,
        currentObjectId: data.case.id,
        otherObjectId: data.aliasTargetId,
        otherObjectPath
      });
    }
    return null;
  }, [basePath, data, spacesApi]);
  return isError ? /*#__PURE__*/_react.default.createElement(_does_not_exist.DoesNotExist, {
    caseId: caseId
  }) : isLoading ? /*#__PURE__*/_react.default.createElement(CaseViewLoading, null) : data ? /*#__PURE__*/_react.default.createElement(_timeline_context.CasesTimelineIntegrationProvider, {
    timelineIntegration: timelineIntegration
  }, getLegacyUrlConflictCallout(), /*#__PURE__*/_react.default.createElement(_case_view_page.CaseViewPage, {
    caseData: data.case,
    caseId: caseId,
    fetchCase: refetch,
    onComponentInitialized: onComponentInitialized,
    actionsNavigation: actionsNavigation,
    ruleDetailsNavigation: ruleDetailsNavigation,
    showAlertDetails: showAlertDetails,
    useFetchAlertData: useFetchAlertData,
    refreshRef: refreshRef
  })) : null;
});
exports.default = exports.CaseView = CaseView;
CaseViewLoading.displayName = 'CaseViewLoading';
CaseView.displayName = 'CaseView';

// eslint-disable-next-line import/no-default-export