"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CaseViewAlerts = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _constants = require("../../../../common/constants");
var _kibana = require("../../../common/lib/kibana");
var _helpers = require("./helpers");
var _use_get_feature_ids = require("../../../containers/use_get_feature_ids");
var _case_view_alerts_empty = require("./case_view_alerts_empty");
var _case_view_tabs = require("../case_view_tabs");
var _types = require("../../../../common/types");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CaseViewAlerts = ({
  caseData
}) => {
  const {
    triggersActionsUi
  } = (0, _kibana.useKibana)().services;
  const alertIdsQuery = (0, _react.useMemo)(() => ({
    ids: {
      values: (0, _helpers.getManualAlertIds)(caseData.comments)
    }
  }), [caseData.comments]);
  const alertRegistrationContexts = (0, _react.useMemo)(() => (0, _helpers.getRegistrationContextFromAlerts)(caseData.comments), [caseData.comments]);
  const {
    isLoading: isLoadingAlertFeatureIds,
    data: alertFeatureIds
  } = (0, _use_get_feature_ids.useGetFeatureIds)(alertRegistrationContexts);
  const configId = caseData.owner === _constants.SECURITY_SOLUTION_OWNER ? `${caseData.owner}-case` : caseData.owner;
  const alertStateProps = {
    alertsTableConfigurationRegistry: triggersActionsUi.alertsTableConfigurationRegistry,
    configurationId: configId,
    id: `case-details-alerts-${caseData.owner}`,
    featureIds: alertFeatureIds !== null && alertFeatureIds !== void 0 ? alertFeatureIds : [],
    query: alertIdsQuery,
    showAlertStatusWithFlapping: caseData.owner !== _constants.SECURITY_SOLUTION_OWNER
  };
  if (alertIdsQuery.ids.values.length === 0) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_case_view_tabs.CaseViewTabs, {
      caseData: caseData,
      activeTab: _types.CASE_VIEW_PAGE_TABS.ALERTS
    }), /*#__PURE__*/_react.default.createElement(_case_view_alerts_empty.CaseViewAlertsEmpty, null)));
  }
  return isLoadingAlertFeatureIds ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiProgress, {
    size: "xs",
    color: "primary"
  }))) : /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    "data-test-subj": "case-view-alerts"
  }, /*#__PURE__*/_react.default.createElement(_case_view_tabs.CaseViewTabs, {
    caseData: caseData,
    activeTab: _types.CASE_VIEW_PAGE_TABS.ALERTS
  }), triggersActionsUi.getAlertsStateTable(alertStateProps));
};
exports.CaseViewAlerts = CaseViewAlerts;
CaseViewAlerts.displayName = 'CaseViewAlerts';