"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useReadonlyHeader = useReadonlyHeader;
var _react = require("react");
var i18n = _interopRequireWildcard(require("./translations"));
var _kibana = require("../../common/lib/kibana");
var _use_cases_context = require("../cases_context/use_cases_context");
var _permissions = require("../../utils/permissions");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * This component places a read-only icon badge in the header if user only has read permissions
 */
function useReadonlyHeader() {
  const {
    permissions
  } = (0, _use_cases_context.useCasesContext)();
  const chrome = (0, _kibana.useKibana)().services.chrome;

  // if the user is read only then display the glasses badge in the global navigation header
  const setBadge = (0, _react.useCallback)(() => {
    if ((0, _permissions.isReadOnlyPermissions)(permissions)) {
      chrome.setBadge({
        text: i18n.READ_ONLY_BADGE_TEXT,
        tooltip: i18n.READ_ONLY_BADGE_TOOLTIP,
        iconType: 'glasses'
      });
    }
  }, [chrome, permissions]);
  (0, _react.useEffect)(() => {
    setBadge();

    // remove the icon after the component unmounts
    return () => {
      chrome.setBadge();
    };
  }, [setBadge, chrome]);
}