"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useCustomFieldsFilterConfig = exports.CUSTOM_FIELD_KEY_PREFIX = void 0;
var _react = _interopRequireDefault(require("react"));
var _builder = require("../../custom_fields/builder");
var _use_get_case_configuration = require("../../../containers/configure/use_get_case_configuration");
var _multi_select_filter = require("../multi_select_filter");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CUSTOM_FIELD_KEY_PREFIX = 'cf_';
exports.CUSTOM_FIELD_KEY_PREFIX = CUSTOM_FIELD_KEY_PREFIX;
const customFieldFilterOptionFactory = ({
  buttonLabel,
  customFieldOptions,
  fieldKey,
  onFilterOptionsChange,
  type
}) => {
  return {
    key: `${CUSTOM_FIELD_KEY_PREFIX}${fieldKey}`,
    // this prefix is set in case custom field has the same key as a system field
    isActive: false,
    isAvailable: true,
    label: buttonLabel,
    getEmptyOptions: () => {
      return {
        customFields: {
          [fieldKey]: {
            type,
            options: []
          }
        }
      };
    },
    render: ({
      filterOptions
    }) => {
      var _filterOptions$custom;
      const onCustomFieldChange = ({
        filterId,
        selectedOptionKeys
      }) => {
        onFilterOptionsChange({
          customFields: {
            [filterId.replace(CUSTOM_FIELD_KEY_PREFIX, '')]: {
              options: selectedOptionKeys,
              type
            }
          }
        });
      };
      return /*#__PURE__*/_react.default.createElement(_multi_select_filter.MultiSelectFilter, {
        buttonLabel: buttonLabel,
        id: fieldKey,
        onChange: onCustomFieldChange,
        options: customFieldOptions.map(option => ({
          key: option.key,
          label: option.label
        })),
        selectedOptionKeys: ((_filterOptions$custom = filterOptions.customFields[fieldKey]) === null || _filterOptions$custom === void 0 ? void 0 : _filterOptions$custom.options) || []
      });
    }
  };
};
const useCustomFieldsFilterConfig = ({
  isSelectorView,
  onFilterOptionsChange
}) => {
  const {
    data: {
      customFields
    }
  } = (0, _use_get_case_configuration.useGetCaseConfiguration)();
  const customFieldsFilterConfig = [];
  if (isSelectorView) {
    return {
      customFieldsFilterConfig: []
    };
  }
  for (const {
    key: fieldKey,
    type,
    label: buttonLabel
  } of customFields !== null && customFields !== void 0 ? customFields : []) {
    if (_builder.builderMap[type]) {
      const {
        filterOptions: customFieldOptions
      } = _builder.builderMap[type]();
      if (customFieldOptions) {
        customFieldsFilterConfig.push(customFieldFilterOptionFactory({
          buttonLabel,
          customFieldOptions,
          fieldKey,
          onFilterOptionsChange,
          type
        }));
      }
    }
  }
  return {
    customFieldsFilterConfig
  };
};
exports.useCustomFieldsFilterConfig = useCustomFieldsFilterConfig;