"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UserActionTypeAll = exports.SortFieldCase = exports.SORT_ORDER_VALUES = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const UserActionTypeAll = 'all';

/**
 * The type for the `refreshRef` prop (a `React.Ref`) defined by the `CaseViewComponentProps`.
 *
 * @example
 * const refreshRef = useRef<CaseViewRefreshPropInterface>(null);
 * return <CaseComponent refreshRef={refreshRef} ...otherProps>
 */
exports.UserActionTypeAll = UserActionTypeAll;
const SORT_ORDER_VALUES = ['asc', 'desc'];
exports.SORT_ORDER_VALUES = SORT_ORDER_VALUES;
let SortFieldCase;
exports.SortFieldCase = SortFieldCase;
(function (SortFieldCase) {
  SortFieldCase["closedAt"] = "closedAt";
  SortFieldCase["createdAt"] = "createdAt";
  SortFieldCase["updatedAt"] = "updatedAt";
  SortFieldCase["severity"] = "severity";
  SortFieldCase["status"] = "status";
  SortFieldCase["title"] = "title";
  SortFieldCase["category"] = "category";
})(SortFieldCase || (exports.SortFieldCase = SortFieldCase = {}));