"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ToggleCustomFieldConfigurationRt = exports.TextCustomFieldConfigurationRt = exports.CustomFieldsConfigurationRt = exports.CustomFieldConfigurationWithoutTypeRt = exports.CustomFieldConfigurationRt = exports.ConfigurationsRt = exports.ConfigurationRt = exports.ConfigurationBasicWithoutOwnerRt = exports.ConfigurationAttributesRt = exports.ConfigurationActivityFieldsRt = exports.ClosureTypeRt = exports.CasesConfigureBasicRt = void 0;
var rt = _interopRequireWildcard(require("io-ts"));
var _v = require("../connector/v1");
var _v2 = require("../user/v1");
var _v3 = require("../custom_field/v1");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ClosureTypeRt = rt.union([rt.literal('close-by-user'), rt.literal('close-by-pushing')]);
exports.ClosureTypeRt = ClosureTypeRt;
const CustomFieldConfigurationWithoutTypeRt = rt.strict({
  /**
   * key of custom field
   */
  key: rt.string,
  /**
   * label of custom field
   */
  label: rt.string,
  /**
   * custom field options - required
   */
  required: rt.boolean
});
exports.CustomFieldConfigurationWithoutTypeRt = CustomFieldConfigurationWithoutTypeRt;
const TextCustomFieldConfigurationRt = rt.intersection([rt.strict({
  type: _v3.CustomFieldTextTypeRt
}), CustomFieldConfigurationWithoutTypeRt]);
exports.TextCustomFieldConfigurationRt = TextCustomFieldConfigurationRt;
const ToggleCustomFieldConfigurationRt = rt.intersection([rt.strict({
  type: _v3.CustomFieldToggleTypeRt
}), CustomFieldConfigurationWithoutTypeRt]);
exports.ToggleCustomFieldConfigurationRt = ToggleCustomFieldConfigurationRt;
const CustomFieldConfigurationRt = rt.union([TextCustomFieldConfigurationRt, ToggleCustomFieldConfigurationRt]);
exports.CustomFieldConfigurationRt = CustomFieldConfigurationRt;
const CustomFieldsConfigurationRt = rt.array(CustomFieldConfigurationRt);
exports.CustomFieldsConfigurationRt = CustomFieldsConfigurationRt;
const ConfigurationBasicWithoutOwnerRt = rt.strict({
  /**
   * The external connector
   */
  connector: _v.CaseConnectorRt,
  /**
   * Whether to close the case after it has been synced with the external system
   */
  closure_type: ClosureTypeRt,
  /**
   * The custom fields configured for the case
   */
  customFields: CustomFieldsConfigurationRt
});
exports.ConfigurationBasicWithoutOwnerRt = ConfigurationBasicWithoutOwnerRt;
const CasesConfigureBasicRt = rt.intersection([ConfigurationBasicWithoutOwnerRt, rt.strict({
  /**
   * The plugin owner that manages this configuration
   */
  owner: rt.string
})]);
exports.CasesConfigureBasicRt = CasesConfigureBasicRt;
const ConfigurationActivityFieldsRt = rt.strict({
  created_at: rt.string,
  created_by: _v2.UserRt,
  updated_at: rt.union([rt.string, rt.null]),
  updated_by: rt.union([_v2.UserRt, rt.null])
});
exports.ConfigurationActivityFieldsRt = ConfigurationActivityFieldsRt;
const ConfigurationAttributesRt = rt.intersection([CasesConfigureBasicRt, ConfigurationActivityFieldsRt]);
exports.ConfigurationAttributesRt = ConfigurationAttributesRt;
const ConfigurationRt = rt.intersection([ConfigurationAttributesRt, rt.strict({
  id: rt.string,
  version: rt.string,
  error: rt.union([rt.string, rt.null]),
  owner: rt.string,
  mappings: _v.ConnectorMappingsRt
})]);
exports.ConfigurationRt = ConfigurationRt;
const ConfigurationsRt = rt.array(ConfigurationRt);
exports.ConfigurationsRt = ConfigurationsRt;