"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CaseStatusRt = exports.CaseSeverityRt = exports.CaseSeverity = exports.CaseSettingsRt = exports.CaseRt = exports.CaseAttributesRt = exports.AttachmentTotalsRt = void 0;
Object.defineProperty(exports, "CaseStatuses", {
  enumerable: true,
  get: function () {
    return _types.CaseStatuses;
  }
});
exports.caseStatuses = exports.RelatedCaseRt = exports.CasesRt = void 0;
var rt = _interopRequireWildcard(require("io-ts"));
var _types = require("@kbn/cases-components/src/status/types");
var _v = require("../external_service/v1");
var _v2 = require("../user/v1");
var _v3 = require("../connector/v1");
var _v4 = require("../attachment/v1");
var _v5 = require("../custom_field/v1");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Status
 */
const CaseStatusRt = rt.union([rt.literal(_types.CaseStatuses.open), rt.literal(_types.CaseStatuses['in-progress']), rt.literal(_types.CaseStatuses.closed)]);
exports.CaseStatusRt = CaseStatusRt;
const caseStatuses = Object.values(_types.CaseStatuses);

/**
 * Severity
 */
exports.caseStatuses = caseStatuses;
let CaseSeverity;
exports.CaseSeverity = CaseSeverity;
(function (CaseSeverity) {
  CaseSeverity["LOW"] = "low";
  CaseSeverity["MEDIUM"] = "medium";
  CaseSeverity["HIGH"] = "high";
  CaseSeverity["CRITICAL"] = "critical";
})(CaseSeverity || (exports.CaseSeverity = CaseSeverity = {}));
const CaseSeverityRt = rt.union([rt.literal(CaseSeverity.LOW), rt.literal(CaseSeverity.MEDIUM), rt.literal(CaseSeverity.HIGH), rt.literal(CaseSeverity.CRITICAL)]);

/**
 * Case
 */
exports.CaseSeverityRt = CaseSeverityRt;
const CaseSettingsRt = rt.strict({
  syncAlerts: rt.boolean
});
exports.CaseSettingsRt = CaseSettingsRt;
const CaseBasicRt = rt.strict({
  /**
   * The description of the case
   */
  description: rt.string,
  /**
   * The current status of the case (open, closed, in-progress)
   */
  status: CaseStatusRt,
  /**
   * The identifying strings for filter a case
   */
  tags: rt.array(rt.string),
  /**
   * The title of a case
   */
  title: rt.string,
  /**
   * The external system that the case can be synced with
   */
  connector: _v3.CaseConnectorRt,
  /**
   * The alert sync settings
   */
  settings: CaseSettingsRt,
  /**
   * The plugin owner of the case
   */
  owner: rt.string,
  /**
   * The severity of the case
   */
  severity: CaseSeverityRt,
  /**
   * The users assigned to this case
   */
  assignees: _v2.CaseAssigneesRt,
  /**
   * The category of the case.
   */
  category: rt.union([rt.string, rt.null]),
  /**
   * An array containing the possible,
   * user-configured custom fields.
   */
  customFields: _v5.CaseCustomFieldsRt
});
const CaseAttributesRt = rt.intersection([CaseBasicRt, rt.strict({
  duration: rt.union([rt.number, rt.null]),
  closed_at: rt.union([rt.string, rt.null]),
  closed_by: rt.union([_v2.UserRt, rt.null]),
  created_at: rt.string,
  created_by: _v2.UserRt,
  external_service: rt.union([_v.ExternalServiceRt, rt.null]),
  updated_at: rt.union([rt.string, rt.null]),
  updated_by: rt.union([_v2.UserRt, rt.null])
})]);
exports.CaseAttributesRt = CaseAttributesRt;
const CaseRt = rt.intersection([CaseAttributesRt, rt.strict({
  id: rt.string,
  totalComment: rt.number,
  totalAlerts: rt.number,
  version: rt.string
}), rt.exact(rt.partial({
  comments: rt.array(_v4.AttachmentRt)
}))]);
exports.CaseRt = CaseRt;
const CasesRt = rt.array(CaseRt);
exports.CasesRt = CasesRt;
const AttachmentTotalsRt = rt.strict({
  alerts: rt.number,
  userComments: rt.number
});
exports.AttachmentTotalsRt = AttachmentTotalsRt;
const RelatedCaseRt = rt.strict({
  id: rt.string,
  title: rt.string,
  description: rt.string,
  status: CaseStatusRt,
  createdAt: rt.string,
  totals: AttachmentTotalsRt
});
exports.RelatedCaseRt = RelatedCaseRt;