"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UserCommentAttachmentRt = exports.UserCommentAttachmentPayloadRt = exports.SingleFileAttachmentMetadataRt = exports.PersistableStateAttachmentRt = exports.PersistableStateAttachmentPayloadRt = exports.IsolateHostActionType = exports.FileAttachmentMetadataRt = exports.ExternalReferenceWithoutRefsAttachmentPayloadRt = exports.ExternalReferenceStorageType = exports.ExternalReferenceSOWithoutRefsAttachmentPayloadRt = exports.ExternalReferenceSOAttachmentPayloadRt = exports.ExternalReferenceNoSOAttachmentPayloadRt = exports.ExternalReferenceAttachmentRt = exports.ExternalReferenceAttachmentPayloadRt = exports.AttachmentsRt = exports.AttachmentType = exports.AttachmentRt = exports.AttachmentPatchAttributesRt = exports.AttachmentAttributesRt = exports.AttachmentAttributesBasicRt = exports.AlertAttachmentRt = exports.AlertAttachmentPayloadRt = exports.AlertAttachmentAttributesRt = exports.ActionsAttachmentRt = exports.ActionsAttachmentPayloadRt = void 0;
var rt = _interopRequireWildcard(require("io-ts"));
var _api = require("../../../api");
var _v = require("../user/v1");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Files
 */
const SingleFileAttachmentMetadataRt = rt.strict({
  name: rt.string,
  extension: rt.string,
  mimeType: rt.string,
  created: rt.string
});
exports.SingleFileAttachmentMetadataRt = SingleFileAttachmentMetadataRt;
const FileAttachmentMetadataRt = rt.strict({
  files: rt.array(SingleFileAttachmentMetadataRt)
});
exports.FileAttachmentMetadataRt = FileAttachmentMetadataRt;
const AttachmentAttributesBasicRt = rt.strict({
  created_at: rt.string,
  created_by: _v.UserRt,
  owner: rt.string,
  pushed_at: rt.union([rt.string, rt.null]),
  pushed_by: rt.union([_v.UserRt, rt.null]),
  updated_at: rt.union([rt.string, rt.null]),
  updated_by: rt.union([_v.UserRt, rt.null])
});

/**
 * User comment
 */
exports.AttachmentAttributesBasicRt = AttachmentAttributesBasicRt;
let AttachmentType;
exports.AttachmentType = AttachmentType;
(function (AttachmentType) {
  AttachmentType["user"] = "user";
  AttachmentType["alert"] = "alert";
  AttachmentType["actions"] = "actions";
  AttachmentType["externalReference"] = "externalReference";
  AttachmentType["persistableState"] = "persistableState";
})(AttachmentType || (exports.AttachmentType = AttachmentType = {}));
const UserCommentAttachmentPayloadRt = rt.strict({
  comment: rt.string,
  type: rt.literal(AttachmentType.user),
  owner: rt.string
});
exports.UserCommentAttachmentPayloadRt = UserCommentAttachmentPayloadRt;
const UserCommentAttachmentAttributesRt = rt.intersection([UserCommentAttachmentPayloadRt, AttachmentAttributesBasicRt]);
const UserCommentAttachmentRt = rt.intersection([UserCommentAttachmentAttributesRt, rt.strict({
  id: rt.string,
  version: rt.string
})]);
exports.UserCommentAttachmentRt = UserCommentAttachmentRt;
/**
 * Alerts
 */

const AlertAttachmentPayloadRt = rt.strict({
  type: rt.literal(AttachmentType.alert),
  alertId: rt.union([rt.array(rt.string), rt.string]),
  index: rt.union([rt.array(rt.string), rt.string]),
  rule: rt.strict({
    id: rt.union([rt.string, rt.null]),
    name: rt.union([rt.string, rt.null])
  }),
  owner: rt.string
});
exports.AlertAttachmentPayloadRt = AlertAttachmentPayloadRt;
const AlertAttachmentAttributesRt = rt.intersection([AlertAttachmentPayloadRt, AttachmentAttributesBasicRt]);
exports.AlertAttachmentAttributesRt = AlertAttachmentAttributesRt;
const AlertAttachmentRt = rt.intersection([AlertAttachmentAttributesRt, rt.strict({
  id: rt.string,
  version: rt.string
})]);
exports.AlertAttachmentRt = AlertAttachmentRt;
/**
 * Actions
 */
let IsolateHostActionType;
exports.IsolateHostActionType = IsolateHostActionType;
(function (IsolateHostActionType) {
  IsolateHostActionType["isolate"] = "isolate";
  IsolateHostActionType["unisolate"] = "unisolate";
})(IsolateHostActionType || (exports.IsolateHostActionType = IsolateHostActionType = {}));
const ActionsAttachmentPayloadRt = rt.strict({
  type: rt.literal(AttachmentType.actions),
  comment: rt.string,
  actions: rt.strict({
    targets: rt.array(rt.strict({
      hostname: rt.string,
      endpointId: rt.string
    })),
    type: rt.string
  }),
  owner: rt.string
});
exports.ActionsAttachmentPayloadRt = ActionsAttachmentPayloadRt;
const ActionsAttachmentAttributesRt = rt.intersection([ActionsAttachmentPayloadRt, AttachmentAttributesBasicRt]);
const ActionsAttachmentRt = rt.intersection([ActionsAttachmentAttributesRt, rt.strict({
  id: rt.string,
  version: rt.string
})]);
exports.ActionsAttachmentRt = ActionsAttachmentRt;
/**
 * External reference
 */
let ExternalReferenceStorageType;
exports.ExternalReferenceStorageType = ExternalReferenceStorageType;
(function (ExternalReferenceStorageType) {
  ExternalReferenceStorageType["savedObject"] = "savedObject";
  ExternalReferenceStorageType["elasticSearchDoc"] = "elasticSearchDoc";
})(ExternalReferenceStorageType || (exports.ExternalReferenceStorageType = ExternalReferenceStorageType = {}));
const ExternalReferenceStorageNoSORt = rt.strict({
  type: rt.literal(ExternalReferenceStorageType.elasticSearchDoc)
});
const ExternalReferenceStorageSORt = rt.strict({
  type: rt.literal(ExternalReferenceStorageType.savedObject),
  soType: rt.string
});
const ExternalReferenceBaseAttachmentPayloadRt = rt.strict({
  externalReferenceAttachmentTypeId: rt.string,
  externalReferenceMetadata: rt.union([rt.null, rt.record(rt.string, _api.jsonValueRt)]),
  type: rt.literal(AttachmentType.externalReference),
  owner: rt.string
});
const ExternalReferenceNoSOAttachmentPayloadRt = rt.strict({
  ...ExternalReferenceBaseAttachmentPayloadRt.type.props,
  externalReferenceId: rt.string,
  externalReferenceStorage: ExternalReferenceStorageNoSORt
});
exports.ExternalReferenceNoSOAttachmentPayloadRt = ExternalReferenceNoSOAttachmentPayloadRt;
const ExternalReferenceSOAttachmentPayloadRt = rt.strict({
  ...ExternalReferenceBaseAttachmentPayloadRt.type.props,
  externalReferenceId: rt.string,
  externalReferenceStorage: ExternalReferenceStorageSORt
});

// externalReferenceId is missing.
exports.ExternalReferenceSOAttachmentPayloadRt = ExternalReferenceSOAttachmentPayloadRt;
const ExternalReferenceSOWithoutRefsAttachmentPayloadRt = rt.strict({
  ...ExternalReferenceBaseAttachmentPayloadRt.type.props,
  externalReferenceStorage: ExternalReferenceStorageSORt
});
exports.ExternalReferenceSOWithoutRefsAttachmentPayloadRt = ExternalReferenceSOWithoutRefsAttachmentPayloadRt;
const ExternalReferenceAttachmentPayloadRt = rt.union([ExternalReferenceNoSOAttachmentPayloadRt, ExternalReferenceSOAttachmentPayloadRt]);
exports.ExternalReferenceAttachmentPayloadRt = ExternalReferenceAttachmentPayloadRt;
const ExternalReferenceWithoutRefsAttachmentPayloadRt = rt.union([ExternalReferenceNoSOAttachmentPayloadRt, ExternalReferenceSOWithoutRefsAttachmentPayloadRt]);
exports.ExternalReferenceWithoutRefsAttachmentPayloadRt = ExternalReferenceWithoutRefsAttachmentPayloadRt;
const ExternalReferenceAttachmentAttributesRt = rt.intersection([ExternalReferenceAttachmentPayloadRt, AttachmentAttributesBasicRt]);
const ExternalReferenceWithoutRefsAttachmentAttributesRt = rt.intersection([ExternalReferenceWithoutRefsAttachmentPayloadRt, AttachmentAttributesBasicRt]);
const ExternalReferenceNoSOAttachmentAttributesRt = rt.intersection([ExternalReferenceNoSOAttachmentPayloadRt, AttachmentAttributesBasicRt]);
const ExternalReferenceSOAttachmentAttributesRt = rt.intersection([ExternalReferenceSOAttachmentPayloadRt, AttachmentAttributesBasicRt]);
const ExternalReferenceAttachmentRt = rt.intersection([ExternalReferenceAttachmentAttributesRt, rt.strict({
  id: rt.string,
  version: rt.string
})]);
exports.ExternalReferenceAttachmentRt = ExternalReferenceAttachmentRt;
/**
 * Persistable state
 */

const PersistableStateAttachmentPayloadRt = rt.strict({
  type: rt.literal(AttachmentType.persistableState),
  owner: rt.string,
  persistableStateAttachmentTypeId: rt.string,
  persistableStateAttachmentState: rt.record(rt.string, _api.jsonValueRt)
});
exports.PersistableStateAttachmentPayloadRt = PersistableStateAttachmentPayloadRt;
const PersistableStateAttachmentAttributesRt = rt.intersection([PersistableStateAttachmentPayloadRt, AttachmentAttributesBasicRt]);
const PersistableStateAttachmentRt = rt.intersection([PersistableStateAttachmentAttributesRt, rt.strict({
  id: rt.string,
  version: rt.string
})]);
exports.PersistableStateAttachmentRt = PersistableStateAttachmentRt;
/**
 * Common
 */

const AttachmentAttributesRt = rt.union([UserCommentAttachmentAttributesRt, AlertAttachmentAttributesRt, ActionsAttachmentAttributesRt, ExternalReferenceAttachmentAttributesRt, PersistableStateAttachmentAttributesRt]);
exports.AttachmentAttributesRt = AttachmentAttributesRt;
const AttachmentAttributesNoSORt = rt.union([UserCommentAttachmentAttributesRt, AlertAttachmentAttributesRt, ActionsAttachmentAttributesRt, ExternalReferenceNoSOAttachmentAttributesRt, PersistableStateAttachmentAttributesRt]);
const AttachmentAttributesWithoutRefsRt = rt.union([UserCommentAttachmentAttributesRt, AlertAttachmentAttributesRt, ActionsAttachmentAttributesRt, ExternalReferenceWithoutRefsAttachmentAttributesRt, PersistableStateAttachmentAttributesRt]);
const AttachmentRt = rt.intersection([AttachmentAttributesRt, rt.strict({
  id: rt.string,
  version: rt.string
})]);
exports.AttachmentRt = AttachmentRt;
const AttachmentsRt = rt.array(AttachmentRt);

/**
 * This type is used by the CaseService.
 * Because the type for the attributes of savedObjectClient update function is Partial<T>
 * we need to make all of our attributes partial too.
 * We ensure that partial updates of CommentContext is not going to happen inside the patch comment route.
 */
exports.AttachmentsRt = AttachmentsRt;
const AttachmentPatchAttributesRt = rt.intersection([rt.union([rt.exact(rt.partial(UserCommentAttachmentPayloadRt.type.props)), rt.exact(rt.partial(AlertAttachmentPayloadRt.type.props)), rt.exact(rt.partial(ActionsAttachmentPayloadRt.type.props)), rt.exact(rt.partial(ExternalReferenceNoSOAttachmentPayloadRt.type.props)), rt.exact(rt.partial(ExternalReferenceSOAttachmentPayloadRt.type.props)), rt.exact(rt.partial(PersistableStateAttachmentPayloadRt.type.props))]), rt.exact(rt.partial(AttachmentAttributesBasicRt.type.props))]);
exports.AttachmentPatchAttributesRt = AttachmentPatchAttributesRt;